// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.fluent.models.SessionPoolUpdatablePropertiesProperties;
import java.io.IOException;
import java.util.List;

/**
 * Container App session pool updatable properties.
 */
@Fluent
public final class SessionPoolUpdatableProperties implements JsonSerializable<SessionPoolUpdatableProperties> {
    /*
     * Session pool resource specific updatable properties.
     */
    private SessionPoolUpdatablePropertiesProperties innerProperties;

    /**
     * Creates an instance of SessionPoolUpdatableProperties class.
     */
    public SessionPoolUpdatableProperties() {
    }

    /**
     * Get the innerProperties property: Session pool resource specific updatable properties.
     * 
     * @return the innerProperties value.
     */
    private SessionPoolUpdatablePropertiesProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the scaleConfiguration property: The scale configuration of the session pool.
     * 
     * @return the scaleConfiguration value.
     */
    public ScaleConfiguration scaleConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().scaleConfiguration();
    }

    /**
     * Set the scaleConfiguration property: The scale configuration of the session pool.
     * 
     * @param scaleConfiguration the scaleConfiguration value to set.
     * @return the SessionPoolUpdatableProperties object itself.
     */
    public SessionPoolUpdatableProperties withScaleConfiguration(ScaleConfiguration scaleConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SessionPoolUpdatablePropertiesProperties();
        }
        this.innerProperties().withScaleConfiguration(scaleConfiguration);
        return this;
    }

    /**
     * Get the secrets property: The secrets of the session pool.
     * 
     * @return the secrets value.
     */
    public List<SessionPoolSecret> secrets() {
        return this.innerProperties() == null ? null : this.innerProperties().secrets();
    }

    /**
     * Set the secrets property: The secrets of the session pool.
     * 
     * @param secrets the secrets value to set.
     * @return the SessionPoolUpdatableProperties object itself.
     */
    public SessionPoolUpdatableProperties withSecrets(List<SessionPoolSecret> secrets) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SessionPoolUpdatablePropertiesProperties();
        }
        this.innerProperties().withSecrets(secrets);
        return this;
    }

    /**
     * Get the dynamicPoolConfiguration property: The pool configuration if the poolManagementType is dynamic.
     * 
     * @return the dynamicPoolConfiguration value.
     */
    public DynamicPoolConfiguration dynamicPoolConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().dynamicPoolConfiguration();
    }

    /**
     * Set the dynamicPoolConfiguration property: The pool configuration if the poolManagementType is dynamic.
     * 
     * @param dynamicPoolConfiguration the dynamicPoolConfiguration value to set.
     * @return the SessionPoolUpdatableProperties object itself.
     */
    public SessionPoolUpdatableProperties
        withDynamicPoolConfiguration(DynamicPoolConfiguration dynamicPoolConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SessionPoolUpdatablePropertiesProperties();
        }
        this.innerProperties().withDynamicPoolConfiguration(dynamicPoolConfiguration);
        return this;
    }

    /**
     * Get the customContainerTemplate property: The custom container configuration if the containerType is
     * CustomContainer.
     * 
     * @return the customContainerTemplate value.
     */
    public CustomContainerTemplate customContainerTemplate() {
        return this.innerProperties() == null ? null : this.innerProperties().customContainerTemplate();
    }

    /**
     * Set the customContainerTemplate property: The custom container configuration if the containerType is
     * CustomContainer.
     * 
     * @param customContainerTemplate the customContainerTemplate value to set.
     * @return the SessionPoolUpdatableProperties object itself.
     */
    public SessionPoolUpdatableProperties withCustomContainerTemplate(CustomContainerTemplate customContainerTemplate) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SessionPoolUpdatablePropertiesProperties();
        }
        this.innerProperties().withCustomContainerTemplate(customContainerTemplate);
        return this;
    }

    /**
     * Get the sessionNetworkConfiguration property: The network configuration of the sessions in the session pool.
     * 
     * @return the sessionNetworkConfiguration value.
     */
    public SessionNetworkConfiguration sessionNetworkConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().sessionNetworkConfiguration();
    }

    /**
     * Set the sessionNetworkConfiguration property: The network configuration of the sessions in the session pool.
     * 
     * @param sessionNetworkConfiguration the sessionNetworkConfiguration value to set.
     * @return the SessionPoolUpdatableProperties object itself.
     */
    public SessionPoolUpdatableProperties
        withSessionNetworkConfiguration(SessionNetworkConfiguration sessionNetworkConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SessionPoolUpdatablePropertiesProperties();
        }
        this.innerProperties().withSessionNetworkConfiguration(sessionNetworkConfiguration);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SessionPoolUpdatableProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SessionPoolUpdatableProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SessionPoolUpdatableProperties.
     */
    public static SessionPoolUpdatableProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SessionPoolUpdatableProperties deserializedSessionPoolUpdatableProperties
                = new SessionPoolUpdatableProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("properties".equals(fieldName)) {
                    deserializedSessionPoolUpdatableProperties.innerProperties
                        = SessionPoolUpdatablePropertiesProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSessionPoolUpdatableProperties;
        });
    }
}
