// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * SMB storage properties.
 */
@Fluent
public final class SmbStorage implements JsonSerializable<SmbStorage> {
    /*
     * The host name or IP address of the SMB server.
     */
    private String host;

    /*
     * The path to the SMB shared folder.
     */
    private String shareName;

    /*
     * The user to log on to the SMB server.
     */
    private String username;

    /*
     * The domain name for the user.
     */
    private String domain;

    /*
     * The password for the user.
     */
    private String password;

    /*
     * Access mode for storage
     */
    private AccessMode accessMode;

    /**
     * Creates an instance of SmbStorage class.
     */
    public SmbStorage() {
    }

    /**
     * Get the host property: The host name or IP address of the SMB server.
     * 
     * @return the host value.
     */
    public String host() {
        return this.host;
    }

    /**
     * Set the host property: The host name or IP address of the SMB server.
     * 
     * @param host the host value to set.
     * @return the SmbStorage object itself.
     */
    public SmbStorage withHost(String host) {
        this.host = host;
        return this;
    }

    /**
     * Get the shareName property: The path to the SMB shared folder.
     * 
     * @return the shareName value.
     */
    public String shareName() {
        return this.shareName;
    }

    /**
     * Set the shareName property: The path to the SMB shared folder.
     * 
     * @param shareName the shareName value to set.
     * @return the SmbStorage object itself.
     */
    public SmbStorage withShareName(String shareName) {
        this.shareName = shareName;
        return this;
    }

    /**
     * Get the username property: The user to log on to the SMB server.
     * 
     * @return the username value.
     */
    public String username() {
        return this.username;
    }

    /**
     * Set the username property: The user to log on to the SMB server.
     * 
     * @param username the username value to set.
     * @return the SmbStorage object itself.
     */
    public SmbStorage withUsername(String username) {
        this.username = username;
        return this;
    }

    /**
     * Get the domain property: The domain name for the user.
     * 
     * @return the domain value.
     */
    public String domain() {
        return this.domain;
    }

    /**
     * Set the domain property: The domain name for the user.
     * 
     * @param domain the domain value to set.
     * @return the SmbStorage object itself.
     */
    public SmbStorage withDomain(String domain) {
        this.domain = domain;
        return this;
    }

    /**
     * Get the password property: The password for the user.
     * 
     * @return the password value.
     */
    public String password() {
        return this.password;
    }

    /**
     * Set the password property: The password for the user.
     * 
     * @param password the password value to set.
     * @return the SmbStorage object itself.
     */
    public SmbStorage withPassword(String password) {
        this.password = password;
        return this;
    }

    /**
     * Get the accessMode property: Access mode for storage.
     * 
     * @return the accessMode value.
     */
    public AccessMode accessMode() {
        return this.accessMode;
    }

    /**
     * Set the accessMode property: Access mode for storage.
     * 
     * @param accessMode the accessMode value to set.
     * @return the SmbStorage object itself.
     */
    public SmbStorage withAccessMode(AccessMode accessMode) {
        this.accessMode = accessMode;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("host", this.host);
        jsonWriter.writeStringField("shareName", this.shareName);
        jsonWriter.writeStringField("username", this.username);
        jsonWriter.writeStringField("domain", this.domain);
        jsonWriter.writeStringField("password", this.password);
        jsonWriter.writeStringField("accessMode", this.accessMode == null ? null : this.accessMode.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SmbStorage from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SmbStorage if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the SmbStorage.
     */
    public static SmbStorage fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SmbStorage deserializedSmbStorage = new SmbStorage();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("host".equals(fieldName)) {
                    deserializedSmbStorage.host = reader.getString();
                } else if ("shareName".equals(fieldName)) {
                    deserializedSmbStorage.shareName = reader.getString();
                } else if ("username".equals(fieldName)) {
                    deserializedSmbStorage.username = reader.getString();
                } else if ("domain".equals(fieldName)) {
                    deserializedSmbStorage.domain = reader.getString();
                } else if ("password".equals(fieldName)) {
                    deserializedSmbStorage.password = reader.getString();
                } else if ("accessMode".equals(fieldName)) {
                    deserializedSmbStorage.accessMode = AccessMode.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSmbStorage;
        });
    }
}
