// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Current provisioning State of the operation.
 */
public final class SourceControlOperationState extends ExpandableStringEnum<SourceControlOperationState> {
    /**
     * Static value InProgress for SourceControlOperationState.
     */
    public static final SourceControlOperationState IN_PROGRESS = fromString("InProgress");

    /**
     * Static value Succeeded for SourceControlOperationState.
     */
    public static final SourceControlOperationState SUCCEEDED = fromString("Succeeded");

    /**
     * Static value Failed for SourceControlOperationState.
     */
    public static final SourceControlOperationState FAILED = fromString("Failed");

    /**
     * Static value Canceled for SourceControlOperationState.
     */
    public static final SourceControlOperationState CANCELED = fromString("Canceled");

    /**
     * Creates a new instance of SourceControlOperationState value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public SourceControlOperationState() {
    }

    /**
     * Creates or finds a SourceControlOperationState from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding SourceControlOperationState.
     */
    public static SourceControlOperationState fromString(String name) {
        return fromString(name, SourceControlOperationState.class);
    }

    /**
     * Gets known SourceControlOperationState values.
     * 
     * @return known SourceControlOperationState values.
     */
    public static Collection<SourceControlOperationState> values() {
        return values(SourceControlOperationState.class);
    }
}
