// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Spring Cloud Config properties.
 */
@Fluent
public final class SpringCloudConfigComponent extends JavaComponentProperties {
    /*
     * Type of the Java Component.
     */
    private JavaComponentType componentType = JavaComponentType.SPRING_CLOUD_CONFIG;

    /*
     * Provisioning state of the Java Component.
     */
    private JavaComponentProvisioningState provisioningState;

    /**
     * Creates an instance of SpringCloudConfigComponent class.
     */
    public SpringCloudConfigComponent() {
    }

    /**
     * Get the componentType property: Type of the Java Component.
     * 
     * @return the componentType value.
     */
    @Override
    public JavaComponentType componentType() {
        return this.componentType;
    }

    /**
     * Get the provisioningState property: Provisioning state of the Java Component.
     * 
     * @return the provisioningState value.
     */
    @Override
    public JavaComponentProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SpringCloudConfigComponent withConfigurations(List<JavaComponentConfigurationProperty> configurations) {
        super.withConfigurations(configurations);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SpringCloudConfigComponent withServiceBinds(List<JavaComponentServiceBind> serviceBinds) {
        super.withServiceBinds(serviceBinds);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("configurations", configurations(), (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("serviceBinds", serviceBinds(), (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("componentType", this.componentType == null ? null : this.componentType.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SpringCloudConfigComponent from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SpringCloudConfigComponent if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SpringCloudConfigComponent.
     */
    public static SpringCloudConfigComponent fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SpringCloudConfigComponent deserializedSpringCloudConfigComponent = new SpringCloudConfigComponent();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("provisioningState".equals(fieldName)) {
                    deserializedSpringCloudConfigComponent.provisioningState
                        = JavaComponentProvisioningState.fromString(reader.getString());
                } else if ("configurations".equals(fieldName)) {
                    List<JavaComponentConfigurationProperty> configurations
                        = reader.readArray(reader1 -> JavaComponentConfigurationProperty.fromJson(reader1));
                    deserializedSpringCloudConfigComponent.withConfigurations(configurations);
                } else if ("serviceBinds".equals(fieldName)) {
                    List<JavaComponentServiceBind> serviceBinds
                        = reader.readArray(reader1 -> JavaComponentServiceBind.fromJson(reader1));
                    deserializedSpringCloudConfigComponent.withServiceBinds(serviceBinds);
                } else if ("componentType".equals(fieldName)) {
                    deserializedSpringCloudConfigComponent.componentType
                        = JavaComponentType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSpringCloudConfigComponent;
        });
    }
}
