// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Storage type for the volume. If not provided, use EmptyDir.
 */
public final class StorageType extends ExpandableStringEnum<StorageType> {
    /**
     * Static value AzureFile for StorageType.
     */
    public static final StorageType AZURE_FILE = fromString("AzureFile");

    /**
     * Static value EmptyDir for StorageType.
     */
    public static final StorageType EMPTY_DIR = fromString("EmptyDir");

    /**
     * Static value Secret for StorageType.
     */
    public static final StorageType SECRET = fromString("Secret");

    /**
     * Static value NfsAzureFile for StorageType.
     */
    public static final StorageType NFS_AZURE_FILE = fromString("NfsAzureFile");

    /**
     * Static value Smb for StorageType.
     */
    public static final StorageType SMB = fromString("Smb");

    /**
     * Creates a new instance of StorageType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public StorageType() {
    }

    /**
     * Creates or finds a StorageType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding StorageType.
     */
    public static StorageType fromString(String name) {
        return fromString(name, StorageType.class);
    }

    /**
     * Gets known StorageType values.
     * 
     * @return known StorageType values.
     */
    public static Collection<StorageType> values() {
        return values(StorageType.class);
    }
}
