// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Defines parameters for tcp connection pooling.
 */
@Fluent
public final class TcpConnectionPool implements JsonSerializable<TcpConnectionPool> {
    /*
     * Maximum number of tcp connections allowed
     */
    private Integer maxConnections;

    /**
     * Creates an instance of TcpConnectionPool class.
     */
    public TcpConnectionPool() {
    }

    /**
     * Get the maxConnections property: Maximum number of tcp connections allowed.
     * 
     * @return the maxConnections value.
     */
    public Integer maxConnections() {
        return this.maxConnections;
    }

    /**
     * Set the maxConnections property: Maximum number of tcp connections allowed.
     * 
     * @param maxConnections the maxConnections value to set.
     * @return the TcpConnectionPool object itself.
     */
    public TcpConnectionPool withMaxConnections(Integer maxConnections) {
        this.maxConnections = maxConnections;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("maxConnections", this.maxConnections);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TcpConnectionPool from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TcpConnectionPool if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the TcpConnectionPool.
     */
    public static TcpConnectionPool fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TcpConnectionPool deserializedTcpConnectionPool = new TcpConnectionPool();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("maxConnections".equals(fieldName)) {
                    deserializedTcpConnectionPool.maxConnections = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTcpConnectionPool;
        });
    }
}
