// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Policy to set request timeouts.
 */
@Fluent
public final class TimeoutPolicy implements JsonSerializable<TimeoutPolicy> {
    /*
     * Timeout, in seconds, for a request to respond
     */
    private Integer responseTimeoutInSeconds;

    /*
     * Timeout, in seconds, for a request to initiate a connection
     */
    private Integer connectionTimeoutInSeconds;

    /**
     * Creates an instance of TimeoutPolicy class.
     */
    public TimeoutPolicy() {
    }

    /**
     * Get the responseTimeoutInSeconds property: Timeout, in seconds, for a request to respond.
     * 
     * @return the responseTimeoutInSeconds value.
     */
    public Integer responseTimeoutInSeconds() {
        return this.responseTimeoutInSeconds;
    }

    /**
     * Set the responseTimeoutInSeconds property: Timeout, in seconds, for a request to respond.
     * 
     * @param responseTimeoutInSeconds the responseTimeoutInSeconds value to set.
     * @return the TimeoutPolicy object itself.
     */
    public TimeoutPolicy withResponseTimeoutInSeconds(Integer responseTimeoutInSeconds) {
        this.responseTimeoutInSeconds = responseTimeoutInSeconds;
        return this;
    }

    /**
     * Get the connectionTimeoutInSeconds property: Timeout, in seconds, for a request to initiate a connection.
     * 
     * @return the connectionTimeoutInSeconds value.
     */
    public Integer connectionTimeoutInSeconds() {
        return this.connectionTimeoutInSeconds;
    }

    /**
     * Set the connectionTimeoutInSeconds property: Timeout, in seconds, for a request to initiate a connection.
     * 
     * @param connectionTimeoutInSeconds the connectionTimeoutInSeconds value to set.
     * @return the TimeoutPolicy object itself.
     */
    public TimeoutPolicy withConnectionTimeoutInSeconds(Integer connectionTimeoutInSeconds) {
        this.connectionTimeoutInSeconds = connectionTimeoutInSeconds;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("responseTimeoutInSeconds", this.responseTimeoutInSeconds);
        jsonWriter.writeNumberField("connectionTimeoutInSeconds", this.connectionTimeoutInSeconds);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TimeoutPolicy from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TimeoutPolicy if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the TimeoutPolicy.
     */
    public static TimeoutPolicy fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TimeoutPolicy deserializedTimeoutPolicy = new TimeoutPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("responseTimeoutInSeconds".equals(fieldName)) {
                    deserializedTimeoutPolicy.responseTimeoutInSeconds = reader.getNullable(JsonReader::getInt);
                } else if ("connectionTimeoutInSeconds".equals(fieldName)) {
                    deserializedTimeoutPolicy.connectionTimeoutInSeconds = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTimeoutPolicy;
        });
    }
}
