// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Configuration of Open Telemetry traces.
 */
@Fluent
public final class TracesConfiguration implements JsonSerializable<TracesConfiguration> {
    /*
     * Open telemetry traces destinations
     */
    private List<String> destinations;

    /**
     * Creates an instance of TracesConfiguration class.
     */
    public TracesConfiguration() {
    }

    /**
     * Get the destinations property: Open telemetry traces destinations.
     * 
     * @return the destinations value.
     */
    public List<String> destinations() {
        return this.destinations;
    }

    /**
     * Set the destinations property: Open telemetry traces destinations.
     * 
     * @param destinations the destinations value to set.
     * @return the TracesConfiguration object itself.
     */
    public TracesConfiguration withDestinations(List<String> destinations) {
        this.destinations = destinations;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("destinations", this.destinations, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TracesConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TracesConfiguration if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the TracesConfiguration.
     */
    public static TracesConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TracesConfiguration deserializedTracesConfiguration = new TracesConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("destinations".equals(fieldName)) {
                    List<String> destinations = reader.readArray(reader1 -> reader1.getString());
                    deserializedTracesConfiguration.destinations = destinations;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTracesConfiguration;
        });
    }
}
