// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.resourcemanager.appcontainers.fluent.models.UsageInner;

/**
 * An immutable client-side representation of Usage.
 */
public interface Usage {
    /**
     * Gets the unit property: An enum describing the unit of usage measurement.
     * 
     * @return the unit value.
     */
    String unit();

    /**
     * Gets the currentValue property: The current usage of the resource.
     * 
     * @return the currentValue value.
     */
    float currentValue();

    /**
     * Gets the limit property: The maximum permitted usage of the resource.
     * 
     * @return the limit value.
     */
    float limit();

    /**
     * Gets the name property: The name of the type of usage.
     * 
     * @return the name value.
     */
    UsageName name();

    /**
     * Gets the inner com.azure.resourcemanager.appcontainers.fluent.models.UsageInner object.
     * 
     * @return the inner object.
     */
    UsageInner innerModel();
}
