// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Volume definitions for the Container App.
 */
@Fluent
public final class Volume implements JsonSerializable<Volume> {
    /*
     * Volume name.
     */
    private String name;

    /*
     * Storage type for the volume. If not provided, use EmptyDir.
     */
    private StorageType storageType;

    /*
     * Name of storage resource. No need to provide for EmptyDir and Secret.
     */
    private String storageName;

    /*
     * List of secrets to be added in volume. If no secrets are provided, all secrets in collection will be added to
     * volume.
     */
    private List<SecretVolumeItem> secrets;

    /*
     * Mount options used while mounting the Azure file share or NFS Azure file share. Must be a comma-separated string.
     */
    private String mountOptions;

    /**
     * Creates an instance of Volume class.
     */
    public Volume() {
    }

    /**
     * Get the name property: Volume name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Volume name.
     * 
     * @param name the name value to set.
     * @return the Volume object itself.
     */
    public Volume withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the storageType property: Storage type for the volume. If not provided, use EmptyDir.
     * 
     * @return the storageType value.
     */
    public StorageType storageType() {
        return this.storageType;
    }

    /**
     * Set the storageType property: Storage type for the volume. If not provided, use EmptyDir.
     * 
     * @param storageType the storageType value to set.
     * @return the Volume object itself.
     */
    public Volume withStorageType(StorageType storageType) {
        this.storageType = storageType;
        return this;
    }

    /**
     * Get the storageName property: Name of storage resource. No need to provide for EmptyDir and Secret.
     * 
     * @return the storageName value.
     */
    public String storageName() {
        return this.storageName;
    }

    /**
     * Set the storageName property: Name of storage resource. No need to provide for EmptyDir and Secret.
     * 
     * @param storageName the storageName value to set.
     * @return the Volume object itself.
     */
    public Volume withStorageName(String storageName) {
        this.storageName = storageName;
        return this;
    }

    /**
     * Get the secrets property: List of secrets to be added in volume. If no secrets are provided, all secrets in
     * collection will be added to volume.
     * 
     * @return the secrets value.
     */
    public List<SecretVolumeItem> secrets() {
        return this.secrets;
    }

    /**
     * Set the secrets property: List of secrets to be added in volume. If no secrets are provided, all secrets in
     * collection will be added to volume.
     * 
     * @param secrets the secrets value to set.
     * @return the Volume object itself.
     */
    public Volume withSecrets(List<SecretVolumeItem> secrets) {
        this.secrets = secrets;
        return this;
    }

    /**
     * Get the mountOptions property: Mount options used while mounting the Azure file share or NFS Azure file share.
     * Must be a comma-separated string.
     * 
     * @return the mountOptions value.
     */
    public String mountOptions() {
        return this.mountOptions;
    }

    /**
     * Set the mountOptions property: Mount options used while mounting the Azure file share or NFS Azure file share.
     * Must be a comma-separated string.
     * 
     * @param mountOptions the mountOptions value to set.
     * @return the Volume object itself.
     */
    public Volume withMountOptions(String mountOptions) {
        this.mountOptions = mountOptions;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (secrets() != null) {
            secrets().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("storageType", this.storageType == null ? null : this.storageType.toString());
        jsonWriter.writeStringField("storageName", this.storageName);
        jsonWriter.writeArrayField("secrets", this.secrets, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("mountOptions", this.mountOptions);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Volume from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Volume if the JsonReader was pointing to an instance of it, or null if it was pointing to
     * JSON null.
     * @throws IOException If an error occurs while reading the Volume.
     */
    public static Volume fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Volume deserializedVolume = new Volume();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedVolume.name = reader.getString();
                } else if ("storageType".equals(fieldName)) {
                    deserializedVolume.storageType = StorageType.fromString(reader.getString());
                } else if ("storageName".equals(fieldName)) {
                    deserializedVolume.storageName = reader.getString();
                } else if ("secrets".equals(fieldName)) {
                    List<SecretVolumeItem> secrets = reader.readArray(reader1 -> SecretVolumeItem.fromJson(reader1));
                    deserializedVolume.secrets = secrets;
                } else if ("mountOptions".equals(fieldName)) {
                    deserializedVolume.mountOptions = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVolume;
        });
    }
}
