// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Workload profile to scope container app execution.
 */
@Fluent
public final class WorkloadProfile implements JsonSerializable<WorkloadProfile> {
    /*
     * Workload profile type for the workloads to run on.
     */
    private String name;

    /*
     * Workload profile type for the workloads to run on.
     */
    private String workloadProfileType;

    /*
     * The minimum capacity.
     */
    private Integer minimumCount;

    /*
     * The maximum capacity.
     */
    private Integer maximumCount;

    /**
     * Creates an instance of WorkloadProfile class.
     */
    public WorkloadProfile() {
    }

    /**
     * Get the name property: Workload profile type for the workloads to run on.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Workload profile type for the workloads to run on.
     * 
     * @param name the name value to set.
     * @return the WorkloadProfile object itself.
     */
    public WorkloadProfile withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the workloadProfileType property: Workload profile type for the workloads to run on.
     * 
     * @return the workloadProfileType value.
     */
    public String workloadProfileType() {
        return this.workloadProfileType;
    }

    /**
     * Set the workloadProfileType property: Workload profile type for the workloads to run on.
     * 
     * @param workloadProfileType the workloadProfileType value to set.
     * @return the WorkloadProfile object itself.
     */
    public WorkloadProfile withWorkloadProfileType(String workloadProfileType) {
        this.workloadProfileType = workloadProfileType;
        return this;
    }

    /**
     * Get the minimumCount property: The minimum capacity.
     * 
     * @return the minimumCount value.
     */
    public Integer minimumCount() {
        return this.minimumCount;
    }

    /**
     * Set the minimumCount property: The minimum capacity.
     * 
     * @param minimumCount the minimumCount value to set.
     * @return the WorkloadProfile object itself.
     */
    public WorkloadProfile withMinimumCount(Integer minimumCount) {
        this.minimumCount = minimumCount;
        return this;
    }

    /**
     * Get the maximumCount property: The maximum capacity.
     * 
     * @return the maximumCount value.
     */
    public Integer maximumCount() {
        return this.maximumCount;
    }

    /**
     * Set the maximumCount property: The maximum capacity.
     * 
     * @param maximumCount the maximumCount value to set.
     * @return the WorkloadProfile object itself.
     */
    public WorkloadProfile withMaximumCount(Integer maximumCount) {
        this.maximumCount = maximumCount;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property name in model WorkloadProfile"));
        }
        if (workloadProfileType() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property workloadProfileType in model WorkloadProfile"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(WorkloadProfile.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("workloadProfileType", this.workloadProfileType);
        jsonWriter.writeNumberField("minimumCount", this.minimumCount);
        jsonWriter.writeNumberField("maximumCount", this.maximumCount);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of WorkloadProfile from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of WorkloadProfile if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the WorkloadProfile.
     */
    public static WorkloadProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WorkloadProfile deserializedWorkloadProfile = new WorkloadProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedWorkloadProfile.name = reader.getString();
                } else if ("workloadProfileType".equals(fieldName)) {
                    deserializedWorkloadProfile.workloadProfileType = reader.getString();
                } else if ("minimumCount".equals(fieldName)) {
                    deserializedWorkloadProfile.minimumCount = reader.getNullable(JsonReader::getInt);
                } else if ("maximumCount".equals(fieldName)) {
                    deserializedWorkloadProfile.maximumCount = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedWorkloadProfile;
        });
    }
}
