// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Workload Profile resource specific properties.
 */
@Fluent
public final class WorkloadProfileStatesProperties implements JsonSerializable<WorkloadProfileStatesProperties> {
    /*
     * Minimum count of instances.
     */
    private Integer minimumCount;

    /*
     * Maximum count of nodes.
     */
    private Integer maximumCount;

    /*
     * Current count of nodes.
     */
    private Integer currentCount;

    /**
     * Creates an instance of WorkloadProfileStatesProperties class.
     */
    public WorkloadProfileStatesProperties() {
    }

    /**
     * Get the minimumCount property: Minimum count of instances.
     * 
     * @return the minimumCount value.
     */
    public Integer minimumCount() {
        return this.minimumCount;
    }

    /**
     * Set the minimumCount property: Minimum count of instances.
     * 
     * @param minimumCount the minimumCount value to set.
     * @return the WorkloadProfileStatesProperties object itself.
     */
    public WorkloadProfileStatesProperties withMinimumCount(Integer minimumCount) {
        this.minimumCount = minimumCount;
        return this;
    }

    /**
     * Get the maximumCount property: Maximum count of nodes.
     * 
     * @return the maximumCount value.
     */
    public Integer maximumCount() {
        return this.maximumCount;
    }

    /**
     * Set the maximumCount property: Maximum count of nodes.
     * 
     * @param maximumCount the maximumCount value to set.
     * @return the WorkloadProfileStatesProperties object itself.
     */
    public WorkloadProfileStatesProperties withMaximumCount(Integer maximumCount) {
        this.maximumCount = maximumCount;
        return this;
    }

    /**
     * Get the currentCount property: Current count of nodes.
     * 
     * @return the currentCount value.
     */
    public Integer currentCount() {
        return this.currentCount;
    }

    /**
     * Set the currentCount property: Current count of nodes.
     * 
     * @param currentCount the currentCount value to set.
     * @return the WorkloadProfileStatesProperties object itself.
     */
    public WorkloadProfileStatesProperties withCurrentCount(Integer currentCount) {
        this.currentCount = currentCount;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("minimumCount", this.minimumCount);
        jsonWriter.writeNumberField("maximumCount", this.maximumCount);
        jsonWriter.writeNumberField("currentCount", this.currentCount);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of WorkloadProfileStatesProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of WorkloadProfileStatesProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the WorkloadProfileStatesProperties.
     */
    public static WorkloadProfileStatesProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WorkloadProfileStatesProperties deserializedWorkloadProfileStatesProperties
                = new WorkloadProfileStatesProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("minimumCount".equals(fieldName)) {
                    deserializedWorkloadProfileStatesProperties.minimumCount = reader.getNullable(JsonReader::getInt);
                } else if ("maximumCount".equals(fieldName)) {
                    deserializedWorkloadProfileStatesProperties.maximumCount = reader.getNullable(JsonReader::getInt);
                } else if ("currentCount".equals(fieldName)) {
                    deserializedWorkloadProfileStatesProperties.currentCount = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedWorkloadProfileStatesProperties;
        });
    }
}
