/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.fluent.models.AppResiliencyProperties;
import com.azure.resourcemanager.appcontainers.models.CircuitBreakerPolicy;
import com.azure.resourcemanager.appcontainers.models.HttpConnectionPool;
import com.azure.resourcemanager.appcontainers.models.HttpRetryPolicy;
import com.azure.resourcemanager.appcontainers.models.TcpConnectionPool;
import com.azure.resourcemanager.appcontainers.models.TcpRetryPolicy;
import com.azure.resourcemanager.appcontainers.models.TimeoutPolicy;
import java.io.IOException;

public final class AppResiliencyInner
extends ProxyResource {
    private AppResiliencyProperties innerProperties;
    private SystemData systemData;
    private String id;
    private String name;
    private String type;

    private AppResiliencyProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public TimeoutPolicy timeoutPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().timeoutPolicy();
    }

    public AppResiliencyInner withTimeoutPolicy(TimeoutPolicy timeoutPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppResiliencyProperties();
        }
        this.innerProperties().withTimeoutPolicy(timeoutPolicy);
        return this;
    }

    public HttpRetryPolicy httpRetryPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().httpRetryPolicy();
    }

    public AppResiliencyInner withHttpRetryPolicy(HttpRetryPolicy httpRetryPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppResiliencyProperties();
        }
        this.innerProperties().withHttpRetryPolicy(httpRetryPolicy);
        return this;
    }

    public TcpRetryPolicy tcpRetryPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().tcpRetryPolicy();
    }

    public AppResiliencyInner withTcpRetryPolicy(TcpRetryPolicy tcpRetryPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppResiliencyProperties();
        }
        this.innerProperties().withTcpRetryPolicy(tcpRetryPolicy);
        return this;
    }

    public CircuitBreakerPolicy circuitBreakerPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().circuitBreakerPolicy();
    }

    public AppResiliencyInner withCircuitBreakerPolicy(CircuitBreakerPolicy circuitBreakerPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppResiliencyProperties();
        }
        this.innerProperties().withCircuitBreakerPolicy(circuitBreakerPolicy);
        return this;
    }

    public HttpConnectionPool httpConnectionPool() {
        return this.innerProperties() == null ? null : this.innerProperties().httpConnectionPool();
    }

    public AppResiliencyInner withHttpConnectionPool(HttpConnectionPool httpConnectionPool) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppResiliencyProperties();
        }
        this.innerProperties().withHttpConnectionPool(httpConnectionPool);
        return this;
    }

    public TcpConnectionPool tcpConnectionPool() {
        return this.innerProperties() == null ? null : this.innerProperties().tcpConnectionPool();
    }

    public AppResiliencyInner withTcpConnectionPool(TcpConnectionPool tcpConnectionPool) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppResiliencyProperties();
        }
        this.innerProperties().withTcpConnectionPool(tcpConnectionPool);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static AppResiliencyInner fromJson(JsonReader jsonReader) throws IOException {
        return (AppResiliencyInner)((Object)jsonReader.readObject(reader -> {
            AppResiliencyInner deserializedAppResiliencyInner = new AppResiliencyInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedAppResiliencyInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedAppResiliencyInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAppResiliencyInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedAppResiliencyInner.innerProperties = AppResiliencyProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedAppResiliencyInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAppResiliencyInner;
        }));
    }
}

