/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.fluent.models.AuthConfigProperties;
import com.azure.resourcemanager.appcontainers.models.AuthPlatform;
import com.azure.resourcemanager.appcontainers.models.EncryptionSettings;
import com.azure.resourcemanager.appcontainers.models.GlobalValidation;
import com.azure.resourcemanager.appcontainers.models.HttpSettings;
import com.azure.resourcemanager.appcontainers.models.IdentityProviders;
import com.azure.resourcemanager.appcontainers.models.Login;
import java.io.IOException;

public final class AuthConfigInner
extends ProxyResource {
    private AuthConfigProperties innerProperties;
    private SystemData systemData;
    private String id;
    private String name;
    private String type;

    private AuthConfigProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public AuthPlatform platform() {
        return this.innerProperties() == null ? null : this.innerProperties().platform();
    }

    public AuthConfigInner withPlatform(AuthPlatform platform) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AuthConfigProperties();
        }
        this.innerProperties().withPlatform(platform);
        return this;
    }

    public GlobalValidation globalValidation() {
        return this.innerProperties() == null ? null : this.innerProperties().globalValidation();
    }

    public AuthConfigInner withGlobalValidation(GlobalValidation globalValidation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AuthConfigProperties();
        }
        this.innerProperties().withGlobalValidation(globalValidation);
        return this;
    }

    public IdentityProviders identityProviders() {
        return this.innerProperties() == null ? null : this.innerProperties().identityProviders();
    }

    public AuthConfigInner withIdentityProviders(IdentityProviders identityProviders) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AuthConfigProperties();
        }
        this.innerProperties().withIdentityProviders(identityProviders);
        return this;
    }

    public Login login() {
        return this.innerProperties() == null ? null : this.innerProperties().login();
    }

    public AuthConfigInner withLogin(Login login) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AuthConfigProperties();
        }
        this.innerProperties().withLogin(login);
        return this;
    }

    public HttpSettings httpSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().httpSettings();
    }

    public AuthConfigInner withHttpSettings(HttpSettings httpSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AuthConfigProperties();
        }
        this.innerProperties().withHttpSettings(httpSettings);
        return this;
    }

    public EncryptionSettings encryptionSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().encryptionSettings();
    }

    public AuthConfigInner withEncryptionSettings(EncryptionSettings encryptionSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AuthConfigProperties();
        }
        this.innerProperties().withEncryptionSettings(encryptionSettings);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static AuthConfigInner fromJson(JsonReader jsonReader) throws IOException {
        return (AuthConfigInner)((Object)jsonReader.readObject(reader -> {
            AuthConfigInner deserializedAuthConfigInner = new AuthConfigInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedAuthConfigInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedAuthConfigInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAuthConfigInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedAuthConfigInner.innerProperties = AuthConfigProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedAuthConfigInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAuthConfigInner;
        }));
    }
}

