/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.BuildConfiguration;
import com.azure.resourcemanager.appcontainers.models.BuildProvisioningState;
import com.azure.resourcemanager.appcontainers.models.BuildStatus;
import com.azure.resourcemanager.appcontainers.models.ContainerRegistryWithCustomImage;
import java.io.IOException;

public final class BuildProperties
implements JsonSerializable<BuildProperties> {
    private BuildProvisioningState provisioningState;
    private BuildStatus buildStatus;
    private ContainerRegistryWithCustomImage destinationContainerRegistry;
    private BuildConfiguration configuration;
    private String uploadEndpoint;
    private String logStreamEndpoint;
    private String tokenEndpoint;

    public BuildProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public BuildStatus buildStatus() {
        return this.buildStatus;
    }

    public ContainerRegistryWithCustomImage destinationContainerRegistry() {
        return this.destinationContainerRegistry;
    }

    public BuildProperties withDestinationContainerRegistry(ContainerRegistryWithCustomImage destinationContainerRegistry) {
        this.destinationContainerRegistry = destinationContainerRegistry;
        return this;
    }

    public BuildConfiguration configuration() {
        return this.configuration;
    }

    public BuildProperties withConfiguration(BuildConfiguration configuration) {
        this.configuration = configuration;
        return this;
    }

    public String uploadEndpoint() {
        return this.uploadEndpoint;
    }

    public String logStreamEndpoint() {
        return this.logStreamEndpoint;
    }

    public String tokenEndpoint() {
        return this.tokenEndpoint;
    }

    public void validate() {
        if (this.destinationContainerRegistry() != null) {
            this.destinationContainerRegistry().validate();
        }
        if (this.configuration() != null) {
            this.configuration().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("destinationContainerRegistry", (JsonSerializable)this.destinationContainerRegistry);
        jsonWriter.writeJsonField("configuration", (JsonSerializable)this.configuration);
        return jsonWriter.writeEndObject();
    }

    public static BuildProperties fromJson(JsonReader jsonReader) throws IOException {
        return (BuildProperties)jsonReader.readObject(reader -> {
            BuildProperties deserializedBuildProperties = new BuildProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedBuildProperties.provisioningState = BuildProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("buildStatus".equals(fieldName)) {
                    deserializedBuildProperties.buildStatus = BuildStatus.fromString(reader.getString());
                    continue;
                }
                if ("destinationContainerRegistry".equals(fieldName)) {
                    deserializedBuildProperties.destinationContainerRegistry = ContainerRegistryWithCustomImage.fromJson(reader);
                    continue;
                }
                if ("configuration".equals(fieldName)) {
                    deserializedBuildProperties.configuration = BuildConfiguration.fromJson(reader);
                    continue;
                }
                if ("uploadEndpoint".equals(fieldName)) {
                    deserializedBuildProperties.uploadEndpoint = reader.getString();
                    continue;
                }
                if ("logStreamEndpoint".equals(fieldName)) {
                    deserializedBuildProperties.logStreamEndpoint = reader.getString();
                    continue;
                }
                if ("tokenEndpoint".equals(fieldName)) {
                    deserializedBuildProperties.tokenEndpoint = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBuildProperties;
        });
    }
}

