/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.fluent.models.BuilderProperties;
import com.azure.resourcemanager.appcontainers.models.BuilderProvisioningState;
import com.azure.resourcemanager.appcontainers.models.ContainerRegistry;
import com.azure.resourcemanager.appcontainers.models.ManagedServiceIdentity;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class BuilderResourceInner
extends Resource {
    private BuilderProperties innerProperties;
    private ManagedServiceIdentity identity;
    private SystemData systemData;
    private String id;
    private String name;
    private String type;

    private BuilderProperties innerProperties() {
        return this.innerProperties;
    }

    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    public BuilderResourceInner withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public BuilderResourceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public BuilderResourceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public BuilderProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String environmentId() {
        return this.innerProperties() == null ? null : this.innerProperties().environmentId();
    }

    public BuilderResourceInner withEnvironmentId(String environmentId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BuilderProperties();
        }
        this.innerProperties().withEnvironmentId(environmentId);
        return this;
    }

    public List<ContainerRegistry> containerRegistries() {
        return this.innerProperties() == null ? null : this.innerProperties().containerRegistries();
    }

    public BuilderResourceInner withContainerRegistries(List<ContainerRegistry> containerRegistries) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BuilderProperties();
        }
        this.innerProperties().withContainerRegistries(containerRegistries);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        return jsonWriter.writeEndObject();
    }

    public static BuilderResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return (BuilderResourceInner)((Object)jsonReader.readObject(reader -> {
            BuilderResourceInner deserializedBuilderResourceInner = new BuilderResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedBuilderResourceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedBuilderResourceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedBuilderResourceInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedBuilderResourceInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedBuilderResourceInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedBuilderResourceInner.innerProperties = BuilderProperties.fromJson(reader);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedBuilderResourceInner.identity = ManagedServiceIdentity.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedBuilderResourceInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBuilderResourceInner;
        }));
    }
}

