/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.fluent.models.ContainerAppsBuildProperties;
import com.azure.resourcemanager.appcontainers.models.BuildProvisioningState;
import com.azure.resourcemanager.appcontainers.models.BuildStatus;
import com.azure.resourcemanager.appcontainers.models.ContainerAppsBuildConfiguration;
import com.azure.resourcemanager.appcontainers.models.ContainerRegistryWithCustomImage;
import java.io.IOException;

public final class ContainerAppsBuildResourceInner
extends ProxyResource {
    private ContainerAppsBuildProperties innerProperties;
    private SystemData systemData;
    private String id;
    private String name;
    private String type;

    private ContainerAppsBuildProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public BuildProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public BuildStatus buildStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().buildStatus();
    }

    public ContainerRegistryWithCustomImage destinationContainerRegistry() {
        return this.innerProperties() == null ? null : this.innerProperties().destinationContainerRegistry();
    }

    public ContainerAppsBuildConfiguration configuration() {
        return this.innerProperties() == null ? null : this.innerProperties().configuration();
    }

    public String logStreamEndpoint() {
        return this.innerProperties() == null ? null : this.innerProperties().logStreamEndpoint();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ContainerAppsBuildResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return (ContainerAppsBuildResourceInner)((Object)jsonReader.readObject(reader -> {
            ContainerAppsBuildResourceInner deserializedContainerAppsBuildResourceInner = new ContainerAppsBuildResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedContainerAppsBuildResourceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedContainerAppsBuildResourceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedContainerAppsBuildResourceInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedContainerAppsBuildResourceInner.innerProperties = ContainerAppsBuildProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedContainerAppsBuildResourceInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedContainerAppsBuildResourceInner;
        }));
    }
}

