/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.fluent.models.DaprSubscriptionProperties;
import com.azure.resourcemanager.appcontainers.models.DaprSubscriptionBulkSubscribeOptions;
import com.azure.resourcemanager.appcontainers.models.DaprSubscriptionRoutes;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class DaprSubscriptionInner
extends ProxyResource {
    private DaprSubscriptionProperties innerProperties;
    private SystemData systemData;
    private String id;
    private String name;
    private String type;

    private DaprSubscriptionProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public String pubsubName() {
        return this.innerProperties() == null ? null : this.innerProperties().pubsubName();
    }

    public DaprSubscriptionInner withPubsubName(String pubsubName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DaprSubscriptionProperties();
        }
        this.innerProperties().withPubsubName(pubsubName);
        return this;
    }

    public String topic() {
        return this.innerProperties() == null ? null : this.innerProperties().topic();
    }

    public DaprSubscriptionInner withTopic(String topic) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DaprSubscriptionProperties();
        }
        this.innerProperties().withTopic(topic);
        return this;
    }

    public String deadLetterTopic() {
        return this.innerProperties() == null ? null : this.innerProperties().deadLetterTopic();
    }

    public DaprSubscriptionInner withDeadLetterTopic(String deadLetterTopic) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DaprSubscriptionProperties();
        }
        this.innerProperties().withDeadLetterTopic(deadLetterTopic);
        return this;
    }

    public DaprSubscriptionRoutes routes() {
        return this.innerProperties() == null ? null : this.innerProperties().routes();
    }

    public DaprSubscriptionInner withRoutes(DaprSubscriptionRoutes routes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DaprSubscriptionProperties();
        }
        this.innerProperties().withRoutes(routes);
        return this;
    }

    public List<String> scopes() {
        return this.innerProperties() == null ? null : this.innerProperties().scopes();
    }

    public DaprSubscriptionInner withScopes(List<String> scopes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DaprSubscriptionProperties();
        }
        this.innerProperties().withScopes(scopes);
        return this;
    }

    public Map<String, String> metadata() {
        return this.innerProperties() == null ? null : this.innerProperties().metadata();
    }

    public DaprSubscriptionInner withMetadata(Map<String, String> metadata) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DaprSubscriptionProperties();
        }
        this.innerProperties().withMetadata(metadata);
        return this;
    }

    public DaprSubscriptionBulkSubscribeOptions bulkSubscribe() {
        return this.innerProperties() == null ? null : this.innerProperties().bulkSubscribe();
    }

    public DaprSubscriptionInner withBulkSubscribe(DaprSubscriptionBulkSubscribeOptions bulkSubscribe) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DaprSubscriptionProperties();
        }
        this.innerProperties().withBulkSubscribe(bulkSubscribe);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static DaprSubscriptionInner fromJson(JsonReader jsonReader) throws IOException {
        return (DaprSubscriptionInner)((Object)jsonReader.readObject(reader -> {
            DaprSubscriptionInner deserializedDaprSubscriptionInner = new DaprSubscriptionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedDaprSubscriptionInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDaprSubscriptionInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDaprSubscriptionInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedDaprSubscriptionInner.innerProperties = DaprSubscriptionProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedDaprSubscriptionInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDaprSubscriptionInner;
        }));
    }
}

