/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.fluent.models.EnvironmentAuthTokenProperties;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;

public final class EnvironmentAuthTokenInner
extends Resource {
    private EnvironmentAuthTokenProperties innerProperties;
    private SystemData systemData;
    private String id;
    private String name;
    private String type;

    private EnvironmentAuthTokenProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public EnvironmentAuthTokenInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public EnvironmentAuthTokenInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String token() {
        return this.innerProperties() == null ? null : this.innerProperties().token();
    }

    public OffsetDateTime expires() {
        return this.innerProperties() == null ? null : this.innerProperties().expires();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static EnvironmentAuthTokenInner fromJson(JsonReader jsonReader) throws IOException {
        return (EnvironmentAuthTokenInner)((Object)jsonReader.readObject(reader -> {
            EnvironmentAuthTokenInner deserializedEnvironmentAuthTokenInner = new EnvironmentAuthTokenInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedEnvironmentAuthTokenInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedEnvironmentAuthTokenInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedEnvironmentAuthTokenInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedEnvironmentAuthTokenInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedEnvironmentAuthTokenInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedEnvironmentAuthTokenInner.innerProperties = EnvironmentAuthTokenProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedEnvironmentAuthTokenInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEnvironmentAuthTokenInner;
        }));
    }
}

