/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.fluent.models.ManagedEnvironmentProperties;
import com.azure.resourcemanager.appcontainers.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.appcontainers.models.AppInsightsConfiguration;
import com.azure.resourcemanager.appcontainers.models.AppLogsConfiguration;
import com.azure.resourcemanager.appcontainers.models.CustomDomainConfiguration;
import com.azure.resourcemanager.appcontainers.models.DaprConfiguration;
import com.azure.resourcemanager.appcontainers.models.EnvironmentProvisioningState;
import com.azure.resourcemanager.appcontainers.models.KedaConfiguration;
import com.azure.resourcemanager.appcontainers.models.ManagedEnvironmentPropertiesPeerAuthentication;
import com.azure.resourcemanager.appcontainers.models.ManagedEnvironmentPropertiesPeerTrafficConfiguration;
import com.azure.resourcemanager.appcontainers.models.ManagedServiceIdentity;
import com.azure.resourcemanager.appcontainers.models.OpenTelemetryConfiguration;
import com.azure.resourcemanager.appcontainers.models.PublicNetworkAccess;
import com.azure.resourcemanager.appcontainers.models.VnetConfiguration;
import com.azure.resourcemanager.appcontainers.models.WorkloadProfile;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class ManagedEnvironmentInner
extends Resource {
    private String kind;
    private ManagedServiceIdentity identity;
    private ManagedEnvironmentProperties innerProperties;
    private SystemData systemData;
    private String id;
    private String name;
    private String type;

    public String kind() {
        return this.kind;
    }

    public ManagedEnvironmentInner withKind(String kind) {
        this.kind = kind;
        return this;
    }

    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    public ManagedEnvironmentInner withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    private ManagedEnvironmentProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public ManagedEnvironmentInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ManagedEnvironmentInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public EnvironmentProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String daprAIInstrumentationKey() {
        return this.innerProperties() == null ? null : this.innerProperties().daprAIInstrumentationKey();
    }

    public ManagedEnvironmentInner withDaprAIInstrumentationKey(String daprAIInstrumentationKey) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedEnvironmentProperties();
        }
        this.innerProperties().withDaprAIInstrumentationKey(daprAIInstrumentationKey);
        return this;
    }

    public String daprAIConnectionString() {
        return this.innerProperties() == null ? null : this.innerProperties().daprAIConnectionString();
    }

    public ManagedEnvironmentInner withDaprAIConnectionString(String daprAIConnectionString) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedEnvironmentProperties();
        }
        this.innerProperties().withDaprAIConnectionString(daprAIConnectionString);
        return this;
    }

    public VnetConfiguration vnetConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().vnetConfiguration();
    }

    public ManagedEnvironmentInner withVnetConfiguration(VnetConfiguration vnetConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedEnvironmentProperties();
        }
        this.innerProperties().withVnetConfiguration(vnetConfiguration);
        return this;
    }

    public String deploymentErrors() {
        return this.innerProperties() == null ? null : this.innerProperties().deploymentErrors();
    }

    public String defaultDomain() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultDomain();
    }

    public String staticIp() {
        return this.innerProperties() == null ? null : this.innerProperties().staticIp();
    }

    public AppLogsConfiguration appLogsConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().appLogsConfiguration();
    }

    public ManagedEnvironmentInner withAppLogsConfiguration(AppLogsConfiguration appLogsConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedEnvironmentProperties();
        }
        this.innerProperties().withAppLogsConfiguration(appLogsConfiguration);
        return this;
    }

    public AppInsightsConfiguration appInsightsConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().appInsightsConfiguration();
    }

    public ManagedEnvironmentInner withAppInsightsConfiguration(AppInsightsConfiguration appInsightsConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedEnvironmentProperties();
        }
        this.innerProperties().withAppInsightsConfiguration(appInsightsConfiguration);
        return this;
    }

    public OpenTelemetryConfiguration openTelemetryConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().openTelemetryConfiguration();
    }

    public ManagedEnvironmentInner withOpenTelemetryConfiguration(OpenTelemetryConfiguration openTelemetryConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedEnvironmentProperties();
        }
        this.innerProperties().withOpenTelemetryConfiguration(openTelemetryConfiguration);
        return this;
    }

    public Boolean zoneRedundant() {
        return this.innerProperties() == null ? null : this.innerProperties().zoneRedundant();
    }

    public ManagedEnvironmentInner withZoneRedundant(Boolean zoneRedundant) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedEnvironmentProperties();
        }
        this.innerProperties().withZoneRedundant(zoneRedundant);
        return this;
    }

    public CustomDomainConfiguration customDomainConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().customDomainConfiguration();
    }

    public ManagedEnvironmentInner withCustomDomainConfiguration(CustomDomainConfiguration customDomainConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedEnvironmentProperties();
        }
        this.innerProperties().withCustomDomainConfiguration(customDomainConfiguration);
        return this;
    }

    public String eventStreamEndpoint() {
        return this.innerProperties() == null ? null : this.innerProperties().eventStreamEndpoint();
    }

    public List<WorkloadProfile> workloadProfiles() {
        return this.innerProperties() == null ? null : this.innerProperties().workloadProfiles();
    }

    public ManagedEnvironmentInner withWorkloadProfiles(List<WorkloadProfile> workloadProfiles) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedEnvironmentProperties();
        }
        this.innerProperties().withWorkloadProfiles(workloadProfiles);
        return this;
    }

    public KedaConfiguration kedaConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().kedaConfiguration();
    }

    public ManagedEnvironmentInner withKedaConfiguration(KedaConfiguration kedaConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedEnvironmentProperties();
        }
        this.innerProperties().withKedaConfiguration(kedaConfiguration);
        return this;
    }

    public DaprConfiguration daprConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().daprConfiguration();
    }

    public ManagedEnvironmentInner withDaprConfiguration(DaprConfiguration daprConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedEnvironmentProperties();
        }
        this.innerProperties().withDaprConfiguration(daprConfiguration);
        return this;
    }

    public String infrastructureResourceGroup() {
        return this.innerProperties() == null ? null : this.innerProperties().infrastructureResourceGroup();
    }

    public ManagedEnvironmentInner withInfrastructureResourceGroup(String infrastructureResourceGroup) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedEnvironmentProperties();
        }
        this.innerProperties().withInfrastructureResourceGroup(infrastructureResourceGroup);
        return this;
    }

    public ManagedEnvironmentPropertiesPeerAuthentication peerAuthentication() {
        return this.innerProperties() == null ? null : this.innerProperties().peerAuthentication();
    }

    public ManagedEnvironmentInner withPeerAuthentication(ManagedEnvironmentPropertiesPeerAuthentication peerAuthentication) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedEnvironmentProperties();
        }
        this.innerProperties().withPeerAuthentication(peerAuthentication);
        return this;
    }

    public ManagedEnvironmentPropertiesPeerTrafficConfiguration peerTrafficConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().peerTrafficConfiguration();
    }

    public ManagedEnvironmentInner withPeerTrafficConfiguration(ManagedEnvironmentPropertiesPeerTrafficConfiguration peerTrafficConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedEnvironmentProperties();
        }
        this.innerProperties().withPeerTrafficConfiguration(peerTrafficConfiguration);
        return this;
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().privateEndpointConnections();
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccess();
    }

    public ManagedEnvironmentInner withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedEnvironmentProperties();
        }
        this.innerProperties().withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("kind", this.kind);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ManagedEnvironmentInner fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedEnvironmentInner)((Object)jsonReader.readObject(reader -> {
            ManagedEnvironmentInner deserializedManagedEnvironmentInner = new ManagedEnvironmentInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedManagedEnvironmentInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedManagedEnvironmentInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedManagedEnvironmentInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedManagedEnvironmentInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedManagedEnvironmentInner.withTags(tags);
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedManagedEnvironmentInner.kind = reader.getString();
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedManagedEnvironmentInner.identity = ManagedServiceIdentity.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedManagedEnvironmentInner.innerProperties = ManagedEnvironmentProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedManagedEnvironmentInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedEnvironmentInner;
        }));
    }
}

