/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.fluent.models.ReplicaProperties;
import com.azure.resourcemanager.appcontainers.models.ContainerAppReplicaRunningState;
import com.azure.resourcemanager.appcontainers.models.ReplicaContainer;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class ReplicaInner
extends ProxyResource {
    private ReplicaProperties innerProperties;
    private SystemData systemData;
    private String id;
    private String name;
    private String type;

    private ReplicaProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public OffsetDateTime createdTime() {
        return this.innerProperties() == null ? null : this.innerProperties().createdTime();
    }

    public ContainerAppReplicaRunningState runningState() {
        return this.innerProperties() == null ? null : this.innerProperties().runningState();
    }

    public String runningStateDetails() {
        return this.innerProperties() == null ? null : this.innerProperties().runningStateDetails();
    }

    public List<ReplicaContainer> containers() {
        return this.innerProperties() == null ? null : this.innerProperties().containers();
    }

    public ReplicaInner withContainers(List<ReplicaContainer> containers) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ReplicaProperties();
        }
        this.innerProperties().withContainers(containers);
        return this;
    }

    public List<ReplicaContainer> initContainers() {
        return this.innerProperties() == null ? null : this.innerProperties().initContainers();
    }

    public ReplicaInner withInitContainers(List<ReplicaContainer> initContainers) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ReplicaProperties();
        }
        this.innerProperties().withInitContainers(initContainers);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ReplicaInner fromJson(JsonReader jsonReader) throws IOException {
        return (ReplicaInner)((Object)jsonReader.readObject(reader -> {
            ReplicaInner deserializedReplicaInner = new ReplicaInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedReplicaInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedReplicaInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedReplicaInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedReplicaInner.innerProperties = ReplicaProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedReplicaInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedReplicaInner;
        }));
    }
}

