/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.fluent.models.SessionPoolProperties;
import com.azure.resourcemanager.appcontainers.models.ContainerType;
import com.azure.resourcemanager.appcontainers.models.CustomContainerTemplate;
import com.azure.resourcemanager.appcontainers.models.DynamicPoolConfiguration;
import com.azure.resourcemanager.appcontainers.models.PoolManagementType;
import com.azure.resourcemanager.appcontainers.models.ScaleConfiguration;
import com.azure.resourcemanager.appcontainers.models.SessionNetworkConfiguration;
import com.azure.resourcemanager.appcontainers.models.SessionPoolProvisioningState;
import com.azure.resourcemanager.appcontainers.models.SessionPoolSecret;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class SessionPoolInner
extends Resource {
    private SessionPoolProperties innerProperties;
    private SystemData systemData;
    private String id;
    private String name;
    private String type;

    private SessionPoolProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public SessionPoolInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public SessionPoolInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String environmentId() {
        return this.innerProperties() == null ? null : this.innerProperties().environmentId();
    }

    public SessionPoolInner withEnvironmentId(String environmentId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SessionPoolProperties();
        }
        this.innerProperties().withEnvironmentId(environmentId);
        return this;
    }

    public ContainerType containerType() {
        return this.innerProperties() == null ? null : this.innerProperties().containerType();
    }

    public SessionPoolInner withContainerType(ContainerType containerType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SessionPoolProperties();
        }
        this.innerProperties().withContainerType(containerType);
        return this;
    }

    public PoolManagementType poolManagementType() {
        return this.innerProperties() == null ? null : this.innerProperties().poolManagementType();
    }

    public SessionPoolInner withPoolManagementType(PoolManagementType poolManagementType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SessionPoolProperties();
        }
        this.innerProperties().withPoolManagementType(poolManagementType);
        return this;
    }

    public Integer nodeCount() {
        return this.innerProperties() == null ? null : this.innerProperties().nodeCount();
    }

    public ScaleConfiguration scaleConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().scaleConfiguration();
    }

    public SessionPoolInner withScaleConfiguration(ScaleConfiguration scaleConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SessionPoolProperties();
        }
        this.innerProperties().withScaleConfiguration(scaleConfiguration);
        return this;
    }

    public List<SessionPoolSecret> secrets() {
        return this.innerProperties() == null ? null : this.innerProperties().secrets();
    }

    public SessionPoolInner withSecrets(List<SessionPoolSecret> secrets) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SessionPoolProperties();
        }
        this.innerProperties().withSecrets(secrets);
        return this;
    }

    public DynamicPoolConfiguration dynamicPoolConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().dynamicPoolConfiguration();
    }

    public SessionPoolInner withDynamicPoolConfiguration(DynamicPoolConfiguration dynamicPoolConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SessionPoolProperties();
        }
        this.innerProperties().withDynamicPoolConfiguration(dynamicPoolConfiguration);
        return this;
    }

    public CustomContainerTemplate customContainerTemplate() {
        return this.innerProperties() == null ? null : this.innerProperties().customContainerTemplate();
    }

    public SessionPoolInner withCustomContainerTemplate(CustomContainerTemplate customContainerTemplate) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SessionPoolProperties();
        }
        this.innerProperties().withCustomContainerTemplate(customContainerTemplate);
        return this;
    }

    public SessionNetworkConfiguration sessionNetworkConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().sessionNetworkConfiguration();
    }

    public SessionPoolInner withSessionNetworkConfiguration(SessionNetworkConfiguration sessionNetworkConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SessionPoolProperties();
        }
        this.innerProperties().withSessionNetworkConfiguration(sessionNetworkConfiguration);
        return this;
    }

    public String poolManagementEndpoint() {
        return this.innerProperties() == null ? null : this.innerProperties().poolManagementEndpoint();
    }

    public SessionPoolProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static SessionPoolInner fromJson(JsonReader jsonReader) throws IOException {
        return (SessionPoolInner)((Object)jsonReader.readObject(reader -> {
            SessionPoolInner deserializedSessionPoolInner = new SessionPoolInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSessionPoolInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSessionPoolInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSessionPoolInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedSessionPoolInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedSessionPoolInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedSessionPoolInner.innerProperties = SessionPoolProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedSessionPoolInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSessionPoolInner;
        }));
    }
}

