/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.fluent.models.BuildResourceInner;
import com.azure.resourcemanager.appcontainers.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.appcontainers.models.BuildConfiguration;
import com.azure.resourcemanager.appcontainers.models.BuildProvisioningState;
import com.azure.resourcemanager.appcontainers.models.BuildResource;
import com.azure.resourcemanager.appcontainers.models.BuildStatus;
import com.azure.resourcemanager.appcontainers.models.ContainerRegistryWithCustomImage;

public final class BuildResourceImpl
implements BuildResource,
BuildResource.Definition,
BuildResource.Update {
    private BuildResourceInner innerObject;
    private final ContainerAppsApiManager serviceManager;
    private String resourceGroupName;
    private String builderName;
    private String buildName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public BuildProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public BuildStatus buildStatus() {
        return this.innerModel().buildStatus();
    }

    @Override
    public ContainerRegistryWithCustomImage destinationContainerRegistry() {
        return this.innerModel().destinationContainerRegistry();
    }

    @Override
    public BuildConfiguration configuration() {
        return this.innerModel().configuration();
    }

    @Override
    public String uploadEndpoint() {
        return this.innerModel().uploadEndpoint();
    }

    @Override
    public String logStreamEndpoint() {
        return this.innerModel().logStreamEndpoint();
    }

    @Override
    public String tokenEndpoint() {
        return this.innerModel().tokenEndpoint();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public BuildResourceInner innerModel() {
        return this.innerObject;
    }

    private ContainerAppsApiManager manager() {
        return this.serviceManager;
    }

    @Override
    public BuildResourceImpl withExistingBuilder(String resourceGroupName, String builderName) {
        this.resourceGroupName = resourceGroupName;
        this.builderName = builderName;
        return this;
    }

    @Override
    public BuildResource create() {
        this.innerObject = this.serviceManager.serviceClient().getBuilds().createOrUpdate(this.resourceGroupName, this.builderName, this.buildName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public BuildResource create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getBuilds().createOrUpdate(this.resourceGroupName, this.builderName, this.buildName, this.innerModel(), context);
        return this;
    }

    BuildResourceImpl(String name, ContainerAppsApiManager serviceManager) {
        this.innerObject = new BuildResourceInner();
        this.serviceManager = serviceManager;
        this.buildName = name;
    }

    @Override
    public BuildResourceImpl update() {
        return this;
    }

    @Override
    public BuildResource apply() {
        this.innerObject = this.serviceManager.serviceClient().getBuilds().createOrUpdate(this.resourceGroupName, this.builderName, this.buildName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public BuildResource apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getBuilds().createOrUpdate(this.resourceGroupName, this.builderName, this.buildName, this.innerModel(), context);
        return this;
    }

    BuildResourceImpl(BuildResourceInner innerObject, ContainerAppsApiManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.builderName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "builders");
        this.buildName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "builds");
    }

    @Override
    public BuildResource refresh() {
        this.innerObject = (BuildResourceInner)((Object)this.serviceManager.serviceClient().getBuilds().getWithResponse(this.resourceGroupName, this.builderName, this.buildName, Context.NONE).getValue());
        return this;
    }

    @Override
    public BuildResource refresh(Context context) {
        this.innerObject = (BuildResourceInner)((Object)this.serviceManager.serviceClient().getBuilds().getWithResponse(this.resourceGroupName, this.builderName, this.buildName, context).getValue());
        return this;
    }

    @Override
    public BuildResourceImpl withDestinationContainerRegistry(ContainerRegistryWithCustomImage destinationContainerRegistry) {
        this.innerModel().withDestinationContainerRegistry(destinationContainerRegistry);
        return this;
    }

    @Override
    public BuildResourceImpl withConfiguration(BuildConfiguration configuration) {
        this.innerModel().withConfiguration(configuration);
        return this;
    }
}

