/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.fluent.models.ContainerAppInner;
import com.azure.resourcemanager.appcontainers.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.appcontainers.models.Configuration;
import com.azure.resourcemanager.appcontainers.models.ContainerApp;
import com.azure.resourcemanager.appcontainers.models.ContainerAppAuthToken;
import com.azure.resourcemanager.appcontainers.models.ContainerAppPropertiesPatchingConfiguration;
import com.azure.resourcemanager.appcontainers.models.ContainerAppProvisioningState;
import com.azure.resourcemanager.appcontainers.models.CustomHostnameAnalysisResult;
import com.azure.resourcemanager.appcontainers.models.ExtendedLocation;
import com.azure.resourcemanager.appcontainers.models.Kind;
import com.azure.resourcemanager.appcontainers.models.ManagedServiceIdentity;
import com.azure.resourcemanager.appcontainers.models.SecretsCollection;
import com.azure.resourcemanager.appcontainers.models.Template;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class ContainerAppImpl
implements ContainerApp,
ContainerApp.Definition,
ContainerApp.Update {
    private ContainerAppInner innerObject;
    private final ContainerAppsApiManager serviceManager;
    private String resourceGroupName;
    private String containerAppName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public ExtendedLocation extendedLocation() {
        return this.innerModel().extendedLocation();
    }

    @Override
    public ManagedServiceIdentity identity() {
        return this.innerModel().identity();
    }

    @Override
    public String managedBy() {
        return this.innerModel().managedBy();
    }

    @Override
    public Kind kind() {
        return this.innerModel().kind();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public ContainerAppProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public String managedEnvironmentId() {
        return this.innerModel().managedEnvironmentId();
    }

    @Override
    public String environmentId() {
        return this.innerModel().environmentId();
    }

    @Override
    public String workloadProfileName() {
        return this.innerModel().workloadProfileName();
    }

    @Override
    public ContainerAppPropertiesPatchingConfiguration patchingConfiguration() {
        return this.innerModel().patchingConfiguration();
    }

    @Override
    public String latestRevisionName() {
        return this.innerModel().latestRevisionName();
    }

    @Override
    public String latestReadyRevisionName() {
        return this.innerModel().latestReadyRevisionName();
    }

    @Override
    public String latestRevisionFqdn() {
        return this.innerModel().latestRevisionFqdn();
    }

    @Override
    public String customDomainVerificationId() {
        return this.innerModel().customDomainVerificationId();
    }

    @Override
    public Configuration configuration() {
        return this.innerModel().configuration();
    }

    @Override
    public Template template() {
        return this.innerModel().template();
    }

    @Override
    public List<String> outboundIpAddresses() {
        List<String> inner = this.innerModel().outboundIpAddresses();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public String eventStreamEndpoint() {
        return this.innerModel().eventStreamEndpoint();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ContainerAppInner innerModel() {
        return this.innerObject;
    }

    private ContainerAppsApiManager manager() {
        return this.serviceManager;
    }

    @Override
    public ContainerAppImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public ContainerApp create() {
        this.innerObject = this.serviceManager.serviceClient().getContainerApps().createOrUpdate(this.resourceGroupName, this.containerAppName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public ContainerApp create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getContainerApps().createOrUpdate(this.resourceGroupName, this.containerAppName, this.innerModel(), context);
        return this;
    }

    ContainerAppImpl(String name, ContainerAppsApiManager serviceManager) {
        this.innerObject = new ContainerAppInner();
        this.serviceManager = serviceManager;
        this.containerAppName = name;
    }

    @Override
    public ContainerAppImpl update() {
        return this;
    }

    @Override
    public ContainerApp apply() {
        this.innerObject = this.serviceManager.serviceClient().getContainerApps().update(this.resourceGroupName, this.containerAppName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public ContainerApp apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getContainerApps().update(this.resourceGroupName, this.containerAppName, this.innerModel(), context);
        return this;
    }

    ContainerAppImpl(ContainerAppInner innerObject, ContainerAppsApiManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.containerAppName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "containerApps");
    }

    @Override
    public ContainerApp refresh() {
        this.innerObject = (ContainerAppInner)((Object)this.serviceManager.serviceClient().getContainerApps().getByResourceGroupWithResponse(this.resourceGroupName, this.containerAppName, Context.NONE).getValue());
        return this;
    }

    @Override
    public ContainerApp refresh(Context context) {
        this.innerObject = (ContainerAppInner)((Object)this.serviceManager.serviceClient().getContainerApps().getByResourceGroupWithResponse(this.resourceGroupName, this.containerAppName, context).getValue());
        return this;
    }

    @Override
    public Response<CustomHostnameAnalysisResult> listCustomHostnameAnalysisWithResponse(String customHostname, Context context) {
        return this.serviceManager.containerApps().listCustomHostnameAnalysisWithResponse(this.resourceGroupName, this.containerAppName, customHostname, context);
    }

    @Override
    public CustomHostnameAnalysisResult listCustomHostnameAnalysis() {
        return this.serviceManager.containerApps().listCustomHostnameAnalysis(this.resourceGroupName, this.containerAppName);
    }

    @Override
    public Response<SecretsCollection> listSecretsWithResponse(Context context) {
        return this.serviceManager.containerApps().listSecretsWithResponse(this.resourceGroupName, this.containerAppName, context);
    }

    @Override
    public SecretsCollection listSecrets() {
        return this.serviceManager.containerApps().listSecrets(this.resourceGroupName, this.containerAppName);
    }

    @Override
    public Response<ContainerAppAuthToken> getAuthTokenWithResponse(Context context) {
        return this.serviceManager.containerApps().getAuthTokenWithResponse(this.resourceGroupName, this.containerAppName, context);
    }

    @Override
    public ContainerAppAuthToken getAuthToken() {
        return this.serviceManager.containerApps().getAuthToken(this.resourceGroupName, this.containerAppName);
    }

    @Override
    public ContainerApp start() {
        return this.serviceManager.containerApps().start(this.resourceGroupName, this.containerAppName);
    }

    @Override
    public ContainerApp start(Context context) {
        return this.serviceManager.containerApps().start(this.resourceGroupName, this.containerAppName, context);
    }

    @Override
    public ContainerApp stop() {
        return this.serviceManager.containerApps().stop(this.resourceGroupName, this.containerAppName);
    }

    @Override
    public ContainerApp stop(Context context) {
        return this.serviceManager.containerApps().stop(this.resourceGroupName, this.containerAppName, context);
    }

    @Override
    public ContainerAppImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public ContainerAppImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public ContainerAppImpl withTags(Map<String, String> tags) {
        this.innerModel().withTags((Map)tags);
        return this;
    }

    @Override
    public ContainerAppImpl withExtendedLocation(ExtendedLocation extendedLocation) {
        this.innerModel().withExtendedLocation(extendedLocation);
        return this;
    }

    @Override
    public ContainerAppImpl withIdentity(ManagedServiceIdentity identity) {
        this.innerModel().withIdentity(identity);
        return this;
    }

    @Override
    public ContainerAppImpl withManagedBy(String managedBy) {
        this.innerModel().withManagedBy(managedBy);
        return this;
    }

    @Override
    public ContainerAppImpl withKind(Kind kind) {
        this.innerModel().withKind(kind);
        return this;
    }

    @Override
    public ContainerAppImpl withManagedEnvironmentId(String managedEnvironmentId) {
        this.innerModel().withManagedEnvironmentId(managedEnvironmentId);
        return this;
    }

    @Override
    public ContainerAppImpl withEnvironmentId(String environmentId) {
        this.innerModel().withEnvironmentId(environmentId);
        return this;
    }

    @Override
    public ContainerAppImpl withWorkloadProfileName(String workloadProfileName) {
        this.innerModel().withWorkloadProfileName(workloadProfileName);
        return this;
    }

    @Override
    public ContainerAppImpl withPatchingConfiguration(ContainerAppPropertiesPatchingConfiguration patchingConfiguration) {
        this.innerModel().withPatchingConfiguration(patchingConfiguration);
        return this;
    }

    @Override
    public ContainerAppImpl withConfiguration(Configuration configuration) {
        this.innerModel().withConfiguration(configuration);
        return this;
    }

    @Override
    public ContainerAppImpl withTemplate(Template template) {
        this.innerModel().withTemplate(template);
        return this;
    }
}

