/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.fluent.ContainerAppsBuildsByContainerAppsClient;
import com.azure.resourcemanager.appcontainers.fluent.models.ContainerAppsBuildResourceInner;
import com.azure.resourcemanager.appcontainers.implementation.ContainerAppsBuildResourceImpl;
import com.azure.resourcemanager.appcontainers.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.appcontainers.models.ContainerAppsBuildResource;
import com.azure.resourcemanager.appcontainers.models.ContainerAppsBuildsByContainerApps;

public final class ContainerAppsBuildsByContainerAppsImpl
implements ContainerAppsBuildsByContainerApps {
    private static final ClientLogger LOGGER = new ClientLogger(ContainerAppsBuildsByContainerAppsImpl.class);
    private final ContainerAppsBuildsByContainerAppsClient innerClient;
    private final ContainerAppsApiManager serviceManager;

    public ContainerAppsBuildsByContainerAppsImpl(ContainerAppsBuildsByContainerAppsClient innerClient, ContainerAppsApiManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<ContainerAppsBuildResource> list(String resourceGroupName, String containerAppName) {
        PagedIterable<ContainerAppsBuildResourceInner> inner = this.serviceClient().list(resourceGroupName, containerAppName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ContainerAppsBuildResourceImpl((ContainerAppsBuildResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ContainerAppsBuildResource> list(String resourceGroupName, String containerAppName, Context context) {
        PagedIterable<ContainerAppsBuildResourceInner> inner = this.serviceClient().list(resourceGroupName, containerAppName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ContainerAppsBuildResourceImpl((ContainerAppsBuildResourceInner)((Object)inner1), this.manager()));
    }

    private ContainerAppsBuildsByContainerAppsClient serviceClient() {
        return this.innerClient;
    }

    private ContainerAppsApiManager manager() {
        return this.serviceManager;
    }
}

