/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.fluent.models.DaprSubscriptionInner;
import com.azure.resourcemanager.appcontainers.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.appcontainers.models.DaprSubscription;
import com.azure.resourcemanager.appcontainers.models.DaprSubscriptionBulkSubscribeOptions;
import com.azure.resourcemanager.appcontainers.models.DaprSubscriptionRoutes;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class DaprSubscriptionImpl
implements DaprSubscription,
DaprSubscription.Definition,
DaprSubscription.Update {
    private DaprSubscriptionInner innerObject;
    private final ContainerAppsApiManager serviceManager;
    private String resourceGroupName;
    private String environmentName;
    private String name;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String pubsubName() {
        return this.innerModel().pubsubName();
    }

    @Override
    public String topic() {
        return this.innerModel().topic();
    }

    @Override
    public String deadLetterTopic() {
        return this.innerModel().deadLetterTopic();
    }

    @Override
    public DaprSubscriptionRoutes routes() {
        return this.innerModel().routes();
    }

    @Override
    public List<String> scopes() {
        List<String> inner = this.innerModel().scopes();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public Map<String, String> metadata() {
        Map<String, String> inner = this.innerModel().metadata();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public DaprSubscriptionBulkSubscribeOptions bulkSubscribe() {
        return this.innerModel().bulkSubscribe();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public DaprSubscriptionInner innerModel() {
        return this.innerObject;
    }

    private ContainerAppsApiManager manager() {
        return this.serviceManager;
    }

    @Override
    public DaprSubscriptionImpl withExistingManagedEnvironment(String resourceGroupName, String environmentName) {
        this.resourceGroupName = resourceGroupName;
        this.environmentName = environmentName;
        return this;
    }

    @Override
    public DaprSubscription create() {
        this.innerObject = (DaprSubscriptionInner)((Object)this.serviceManager.serviceClient().getDaprSubscriptions().createOrUpdateWithResponse(this.resourceGroupName, this.environmentName, this.name, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public DaprSubscription create(Context context) {
        this.innerObject = (DaprSubscriptionInner)((Object)this.serviceManager.serviceClient().getDaprSubscriptions().createOrUpdateWithResponse(this.resourceGroupName, this.environmentName, this.name, this.innerModel(), context).getValue());
        return this;
    }

    DaprSubscriptionImpl(String name, ContainerAppsApiManager serviceManager) {
        this.innerObject = new DaprSubscriptionInner();
        this.serviceManager = serviceManager;
        this.name = name;
    }

    @Override
    public DaprSubscriptionImpl update() {
        return this;
    }

    @Override
    public DaprSubscription apply() {
        this.innerObject = (DaprSubscriptionInner)((Object)this.serviceManager.serviceClient().getDaprSubscriptions().createOrUpdateWithResponse(this.resourceGroupName, this.environmentName, this.name, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public DaprSubscription apply(Context context) {
        this.innerObject = (DaprSubscriptionInner)((Object)this.serviceManager.serviceClient().getDaprSubscriptions().createOrUpdateWithResponse(this.resourceGroupName, this.environmentName, this.name, this.innerModel(), context).getValue());
        return this;
    }

    DaprSubscriptionImpl(DaprSubscriptionInner innerObject, ContainerAppsApiManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.environmentName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "managedEnvironments");
        this.name = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "daprSubscriptions");
    }

    @Override
    public DaprSubscription refresh() {
        this.innerObject = (DaprSubscriptionInner)((Object)this.serviceManager.serviceClient().getDaprSubscriptions().getWithResponse(this.resourceGroupName, this.environmentName, this.name, Context.NONE).getValue());
        return this;
    }

    @Override
    public DaprSubscription refresh(Context context) {
        this.innerObject = (DaprSubscriptionInner)((Object)this.serviceManager.serviceClient().getDaprSubscriptions().getWithResponse(this.resourceGroupName, this.environmentName, this.name, context).getValue());
        return this;
    }

    @Override
    public DaprSubscriptionImpl withPubsubName(String pubsubName) {
        this.innerModel().withPubsubName(pubsubName);
        return this;
    }

    @Override
    public DaprSubscriptionImpl withTopic(String topic) {
        this.innerModel().withTopic(topic);
        return this;
    }

    @Override
    public DaprSubscriptionImpl withDeadLetterTopic(String deadLetterTopic) {
        this.innerModel().withDeadLetterTopic(deadLetterTopic);
        return this;
    }

    @Override
    public DaprSubscriptionImpl withRoutes(DaprSubscriptionRoutes routes) {
        this.innerModel().withRoutes(routes);
        return this;
    }

    @Override
    public DaprSubscriptionImpl withScopes(List<String> scopes) {
        this.innerModel().withScopes(scopes);
        return this;
    }

    @Override
    public DaprSubscriptionImpl withMetadata(Map<String, String> metadata) {
        this.innerModel().withMetadata(metadata);
        return this;
    }

    @Override
    public DaprSubscriptionImpl withBulkSubscribe(DaprSubscriptionBulkSubscribeOptions bulkSubscribe) {
        this.innerModel().withBulkSubscribe(bulkSubscribe);
        return this;
    }
}

