/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.appcontainers.fluent.FunctionsExtensionsClient;
import com.azure.resourcemanager.appcontainers.implementation.ContainerAppsApiClientImpl;
import com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException;
import reactor.core.publisher.Mono;

public final class FunctionsExtensionsClientImpl
implements FunctionsExtensionsClient {
    private final FunctionsExtensionsService service;
    private final ContainerAppsApiClientImpl client;

    FunctionsExtensionsClientImpl(ContainerAppsApiClientImpl client) {
        this.service = (FunctionsExtensionsService)RestProxy.create(FunctionsExtensionsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<String>> invokeFunctionsHostWithResponseAsync(String resourceGroupName, String containerAppName, String revisionName, String functionAppName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerAppName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerAppName is required and cannot be null."));
        }
        if (revisionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter revisionName is required and cannot be null."));
        }
        if (functionAppName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter functionAppName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.invokeFunctionsHost(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, containerAppName, revisionName, functionAppName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<String>> invokeFunctionsHostWithResponseAsync(String resourceGroupName, String containerAppName, String revisionName, String functionAppName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerAppName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerAppName is required and cannot be null."));
        }
        if (revisionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter revisionName is required and cannot be null."));
        }
        if (functionAppName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter functionAppName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.invokeFunctionsHost(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, containerAppName, revisionName, functionAppName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<String> invokeFunctionsHostAsync(String resourceGroupName, String containerAppName, String revisionName, String functionAppName) {
        return this.invokeFunctionsHostWithResponseAsync(resourceGroupName, containerAppName, revisionName, functionAppName).flatMap(res -> Mono.justOrEmpty((Object)((String)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<String> invokeFunctionsHostWithResponse(String resourceGroupName, String containerAppName, String revisionName, String functionAppName, Context context) {
        return (Response)this.invokeFunctionsHostWithResponseAsync(resourceGroupName, containerAppName, revisionName, functionAppName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public String invokeFunctionsHost(String resourceGroupName, String containerAppName, String revisionName, String functionAppName) {
        return (String)this.invokeFunctionsHostWithResponse(resourceGroupName, containerAppName, revisionName, functionAppName, Context.NONE).getValue();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ContainerAppsApiClie")
    public static interface FunctionsExtensionsService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/containerApps/{containerAppName}/revisions/{revisionName}/providers/Microsoft.App/functions/{functionAppName}/invoke")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<String>> invokeFunctionsHost(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="containerAppName") String var4, @PathParam(value="revisionName") String var5, @PathParam(value="functionAppName") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);
    }
}

