/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.fluent.models.LogicAppInner;
import com.azure.resourcemanager.appcontainers.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.appcontainers.models.LogicApp;
import com.azure.resourcemanager.appcontainers.models.WorkflowArtifacts;
import com.azure.resourcemanager.appcontainers.models.WorkflowEnvelope;

public final class LogicAppImpl
implements LogicApp,
LogicApp.Definition,
LogicApp.Update {
    private LogicAppInner innerObject;
    private final ContainerAppsApiManager serviceManager;
    private String resourceGroupName;
    private String containerAppName;
    private String logicAppName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public Object properties() {
        return this.innerModel().properties();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public LogicAppInner innerModel() {
        return this.innerObject;
    }

    private ContainerAppsApiManager manager() {
        return this.serviceManager;
    }

    @Override
    public LogicAppImpl withExistingContainerApp(String resourceGroupName, String containerAppName) {
        this.resourceGroupName = resourceGroupName;
        this.containerAppName = containerAppName;
        return this;
    }

    @Override
    public LogicApp create() {
        this.innerObject = (LogicAppInner)((Object)this.serviceManager.serviceClient().getLogicApps().createOrUpdateWithResponse(this.resourceGroupName, this.containerAppName, this.logicAppName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public LogicApp create(Context context) {
        this.innerObject = (LogicAppInner)((Object)this.serviceManager.serviceClient().getLogicApps().createOrUpdateWithResponse(this.resourceGroupName, this.containerAppName, this.logicAppName, this.innerModel(), context).getValue());
        return this;
    }

    LogicAppImpl(String name, ContainerAppsApiManager serviceManager) {
        this.innerObject = new LogicAppInner();
        this.serviceManager = serviceManager;
        this.logicAppName = name;
    }

    @Override
    public LogicAppImpl update() {
        return this;
    }

    @Override
    public LogicApp apply() {
        this.innerObject = (LogicAppInner)((Object)this.serviceManager.serviceClient().getLogicApps().createOrUpdateWithResponse(this.resourceGroupName, this.containerAppName, this.logicAppName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public LogicApp apply(Context context) {
        this.innerObject = (LogicAppInner)((Object)this.serviceManager.serviceClient().getLogicApps().createOrUpdateWithResponse(this.resourceGroupName, this.containerAppName, this.logicAppName, this.innerModel(), context).getValue());
        return this;
    }

    LogicAppImpl(LogicAppInner innerObject, ContainerAppsApiManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.containerAppName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "containerApps");
        this.logicAppName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "logicApps");
    }

    @Override
    public LogicApp refresh() {
        this.innerObject = (LogicAppInner)((Object)this.serviceManager.serviceClient().getLogicApps().getWithResponse(this.resourceGroupName, this.containerAppName, this.logicAppName, Context.NONE).getValue());
        return this;
    }

    @Override
    public LogicApp refresh(Context context) {
        this.innerObject = (LogicAppInner)((Object)this.serviceManager.serviceClient().getLogicApps().getWithResponse(this.resourceGroupName, this.containerAppName, this.logicAppName, context).getValue());
        return this;
    }

    @Override
    public Response<Void> deployWorkflowArtifactsWithResponse(WorkflowArtifacts workflowArtifacts, Context context) {
        return this.serviceManager.logicApps().deployWorkflowArtifactsWithResponse(this.resourceGroupName, this.containerAppName, this.logicAppName, workflowArtifacts, context);
    }

    @Override
    public void deployWorkflowArtifacts() {
        this.serviceManager.logicApps().deployWorkflowArtifacts(this.resourceGroupName, this.containerAppName, this.logicAppName);
    }

    @Override
    public Response<WorkflowEnvelope> listWorkflowsConnectionsWithResponse(Context context) {
        return this.serviceManager.logicApps().listWorkflowsConnectionsWithResponse(this.resourceGroupName, this.containerAppName, this.logicAppName, context);
    }

    @Override
    public WorkflowEnvelope listWorkflowsConnections() {
        return this.serviceManager.logicApps().listWorkflowsConnections(this.resourceGroupName, this.containerAppName, this.logicAppName);
    }

    @Override
    public LogicAppImpl withProperties(Object properties) {
        this.innerModel().withProperties(properties);
        return this;
    }
}

