/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.appcontainers.fluent.LogicAppsClient;
import com.azure.resourcemanager.appcontainers.fluent.models.LogicAppInner;
import com.azure.resourcemanager.appcontainers.fluent.models.WorkflowEnvelopeInner;
import com.azure.resourcemanager.appcontainers.implementation.ContainerAppsApiClientImpl;
import com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException;
import com.azure.resourcemanager.appcontainers.models.LogicAppsProxyMethod;
import com.azure.resourcemanager.appcontainers.models.WorkflowArtifacts;
import com.azure.resourcemanager.appcontainers.models.WorkflowEnvelopeCollection;
import reactor.core.publisher.Mono;

public final class LogicAppsClientImpl
implements LogicAppsClient {
    private final LogicAppsService service;
    private final ContainerAppsApiClientImpl client;

    LogicAppsClientImpl(ContainerAppsApiClientImpl client) {
        this.service = (LogicAppsService)RestProxy.create(LogicAppsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<LogicAppInner>> getWithResponseAsync(String resourceGroupName, String containerAppName, String logicAppName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerAppName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerAppName is required and cannot be null."));
        }
        if (logicAppName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter logicAppName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, containerAppName, logicAppName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<LogicAppInner>> getWithResponseAsync(String resourceGroupName, String containerAppName, String logicAppName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerAppName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerAppName is required and cannot be null."));
        }
        if (logicAppName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter logicAppName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, containerAppName, logicAppName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<LogicAppInner> getAsync(String resourceGroupName, String containerAppName, String logicAppName) {
        return this.getWithResponseAsync(resourceGroupName, containerAppName, logicAppName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((LogicAppInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<LogicAppInner> getWithResponse(String resourceGroupName, String containerAppName, String logicAppName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, containerAppName, logicAppName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public LogicAppInner get(String resourceGroupName, String containerAppName, String logicAppName) {
        return (LogicAppInner)((Object)this.getWithResponse(resourceGroupName, containerAppName, logicAppName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<LogicAppInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String containerAppName, String logicAppName, LogicAppInner resource) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerAppName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerAppName is required and cannot be null."));
        }
        if (logicAppName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter logicAppName is required and cannot be null."));
        }
        if (resource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resource is required and cannot be null."));
        }
        resource.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, containerAppName, logicAppName, this.client.getApiVersion(), resource, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<LogicAppInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String containerAppName, String logicAppName, LogicAppInner resource, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerAppName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerAppName is required and cannot be null."));
        }
        if (logicAppName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter logicAppName is required and cannot be null."));
        }
        if (resource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resource is required and cannot be null."));
        }
        resource.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, containerAppName, logicAppName, this.client.getApiVersion(), resource, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<LogicAppInner> createOrUpdateAsync(String resourceGroupName, String containerAppName, String logicAppName, LogicAppInner resource) {
        return this.createOrUpdateWithResponseAsync(resourceGroupName, containerAppName, logicAppName, resource).flatMap(res -> Mono.justOrEmpty((Object)((Object)((LogicAppInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<LogicAppInner> createOrUpdateWithResponse(String resourceGroupName, String containerAppName, String logicAppName, LogicAppInner resource, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(resourceGroupName, containerAppName, logicAppName, resource, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public LogicAppInner createOrUpdate(String resourceGroupName, String containerAppName, String logicAppName, LogicAppInner resource) {
        return (LogicAppInner)((Object)this.createOrUpdateWithResponse(resourceGroupName, containerAppName, logicAppName, resource, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String containerAppName, String logicAppName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerAppName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerAppName is required and cannot be null."));
        }
        if (logicAppName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter logicAppName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, containerAppName, logicAppName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String containerAppName, String logicAppName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerAppName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerAppName is required and cannot be null."));
        }
        if (logicAppName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter logicAppName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, containerAppName, logicAppName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String containerAppName, String logicAppName) {
        return this.deleteWithResponseAsync(resourceGroupName, containerAppName, logicAppName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String containerAppName, String logicAppName, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, containerAppName, logicAppName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String containerAppName, String logicAppName) {
        this.deleteWithResponse(resourceGroupName, containerAppName, logicAppName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<WorkflowEnvelopeInner>> listWorkflowsSinglePageAsync(String resourceGroupName, String containerAppName, String logicAppName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerAppName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerAppName is required and cannot be null."));
        }
        if (logicAppName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter logicAppName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listWorkflows(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, containerAppName, logicAppName, this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((WorkflowEnvelopeCollection)res.getValue()).value(), ((WorkflowEnvelopeCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<WorkflowEnvelopeInner>> listWorkflowsSinglePageAsync(String resourceGroupName, String containerAppName, String logicAppName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerAppName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerAppName is required and cannot be null."));
        }
        if (logicAppName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter logicAppName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listWorkflows(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, containerAppName, logicAppName, this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((WorkflowEnvelopeCollection)res.getValue()).value(), ((WorkflowEnvelopeCollection)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<WorkflowEnvelopeInner> listWorkflowsAsync(String resourceGroupName, String containerAppName, String logicAppName) {
        return new PagedFlux(() -> this.listWorkflowsSinglePageAsync(resourceGroupName, containerAppName, logicAppName), nextLink -> this.listWorkflowsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<WorkflowEnvelopeInner> listWorkflowsAsync(String resourceGroupName, String containerAppName, String logicAppName, Context context) {
        return new PagedFlux(() -> this.listWorkflowsSinglePageAsync(resourceGroupName, containerAppName, logicAppName, context), nextLink -> this.listWorkflowsNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<WorkflowEnvelopeInner> listWorkflows(String resourceGroupName, String containerAppName, String logicAppName) {
        return new PagedIterable(this.listWorkflowsAsync(resourceGroupName, containerAppName, logicAppName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<WorkflowEnvelopeInner> listWorkflows(String resourceGroupName, String containerAppName, String logicAppName, Context context) {
        return new PagedIterable(this.listWorkflowsAsync(resourceGroupName, containerAppName, logicAppName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<WorkflowEnvelopeInner>> getWorkflowWithResponseAsync(String resourceGroupName, String containerAppName, String logicAppName, String workflowName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerAppName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerAppName is required and cannot be null."));
        }
        if (logicAppName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter logicAppName is required and cannot be null."));
        }
        if (workflowName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workflowName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getWorkflow(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, containerAppName, logicAppName, workflowName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<WorkflowEnvelopeInner>> getWorkflowWithResponseAsync(String resourceGroupName, String containerAppName, String logicAppName, String workflowName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerAppName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerAppName is required and cannot be null."));
        }
        if (logicAppName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter logicAppName is required and cannot be null."));
        }
        if (workflowName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workflowName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getWorkflow(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, containerAppName, logicAppName, workflowName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<WorkflowEnvelopeInner> getWorkflowAsync(String resourceGroupName, String containerAppName, String logicAppName, String workflowName) {
        return this.getWorkflowWithResponseAsync(resourceGroupName, containerAppName, logicAppName, workflowName).flatMap(res -> Mono.justOrEmpty((Object)((WorkflowEnvelopeInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<WorkflowEnvelopeInner> getWorkflowWithResponse(String resourceGroupName, String containerAppName, String logicAppName, String workflowName, Context context) {
        return (Response)this.getWorkflowWithResponseAsync(resourceGroupName, containerAppName, logicAppName, workflowName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public WorkflowEnvelopeInner getWorkflow(String resourceGroupName, String containerAppName, String logicAppName, String workflowName) {
        return (WorkflowEnvelopeInner)this.getWorkflowWithResponse(resourceGroupName, containerAppName, logicAppName, workflowName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deployWorkflowArtifactsWithResponseAsync(String resourceGroupName, String containerAppName, String logicAppName, WorkflowArtifacts workflowArtifacts) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerAppName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerAppName is required and cannot be null."));
        }
        if (logicAppName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter logicAppName is required and cannot be null."));
        }
        if (workflowArtifacts != null) {
            workflowArtifacts.validate();
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deployWorkflowArtifacts(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, containerAppName, logicAppName, this.client.getApiVersion(), workflowArtifacts, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deployWorkflowArtifactsWithResponseAsync(String resourceGroupName, String containerAppName, String logicAppName, WorkflowArtifacts workflowArtifacts, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerAppName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerAppName is required and cannot be null."));
        }
        if (logicAppName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter logicAppName is required and cannot be null."));
        }
        if (workflowArtifacts != null) {
            workflowArtifacts.validate();
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deployWorkflowArtifacts(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, containerAppName, logicAppName, this.client.getApiVersion(), workflowArtifacts, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deployWorkflowArtifactsAsync(String resourceGroupName, String containerAppName, String logicAppName) {
        WorkflowArtifacts workflowArtifacts = null;
        return this.deployWorkflowArtifactsWithResponseAsync(resourceGroupName, containerAppName, logicAppName, workflowArtifacts).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deployWorkflowArtifactsWithResponse(String resourceGroupName, String containerAppName, String logicAppName, WorkflowArtifacts workflowArtifacts, Context context) {
        return (Response)this.deployWorkflowArtifactsWithResponseAsync(resourceGroupName, containerAppName, logicAppName, workflowArtifacts, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deployWorkflowArtifacts(String resourceGroupName, String containerAppName, String logicAppName) {
        WorkflowArtifacts workflowArtifacts = null;
        this.deployWorkflowArtifactsWithResponse(resourceGroupName, containerAppName, logicAppName, workflowArtifacts, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<WorkflowEnvelopeInner>> listWorkflowsConnectionsWithResponseAsync(String resourceGroupName, String containerAppName, String logicAppName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerAppName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerAppName is required and cannot be null."));
        }
        if (logicAppName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter logicAppName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listWorkflowsConnections(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, containerAppName, logicAppName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<WorkflowEnvelopeInner>> listWorkflowsConnectionsWithResponseAsync(String resourceGroupName, String containerAppName, String logicAppName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerAppName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerAppName is required and cannot be null."));
        }
        if (logicAppName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter logicAppName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listWorkflowsConnections(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, containerAppName, logicAppName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<WorkflowEnvelopeInner> listWorkflowsConnectionsAsync(String resourceGroupName, String containerAppName, String logicAppName) {
        return this.listWorkflowsConnectionsWithResponseAsync(resourceGroupName, containerAppName, logicAppName).flatMap(res -> Mono.justOrEmpty((Object)((WorkflowEnvelopeInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<WorkflowEnvelopeInner> listWorkflowsConnectionsWithResponse(String resourceGroupName, String containerAppName, String logicAppName, Context context) {
        return (Response)this.listWorkflowsConnectionsWithResponseAsync(resourceGroupName, containerAppName, logicAppName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public WorkflowEnvelopeInner listWorkflowsConnections(String resourceGroupName, String containerAppName, String logicAppName) {
        return (WorkflowEnvelopeInner)this.listWorkflowsConnectionsWithResponse(resourceGroupName, containerAppName, logicAppName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Object>> invokeWithResponseAsync(String resourceGroupName, String containerAppName, String logicAppName, String xMsLogicAppsProxyPath, LogicAppsProxyMethod xMsLogicAppsProxyMethod) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerAppName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerAppName is required and cannot be null."));
        }
        if (logicAppName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter logicAppName is required and cannot be null."));
        }
        if (xMsLogicAppsProxyPath == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter xMsLogicAppsProxyPath is required and cannot be null."));
        }
        if (xMsLogicAppsProxyMethod == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter xMsLogicAppsProxyMethod is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.invoke(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, containerAppName, logicAppName, xMsLogicAppsProxyPath, xMsLogicAppsProxyMethod, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Object>> invokeWithResponseAsync(String resourceGroupName, String containerAppName, String logicAppName, String xMsLogicAppsProxyPath, LogicAppsProxyMethod xMsLogicAppsProxyMethod, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerAppName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerAppName is required and cannot be null."));
        }
        if (logicAppName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter logicAppName is required and cannot be null."));
        }
        if (xMsLogicAppsProxyPath == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter xMsLogicAppsProxyPath is required and cannot be null."));
        }
        if (xMsLogicAppsProxyMethod == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter xMsLogicAppsProxyMethod is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.invoke(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, containerAppName, logicAppName, xMsLogicAppsProxyPath, xMsLogicAppsProxyMethod, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Object> invokeAsync(String resourceGroupName, String containerAppName, String logicAppName, String xMsLogicAppsProxyPath, LogicAppsProxyMethod xMsLogicAppsProxyMethod) {
        return this.invokeWithResponseAsync(resourceGroupName, containerAppName, logicAppName, xMsLogicAppsProxyPath, xMsLogicAppsProxyMethod).flatMap(res -> Mono.justOrEmpty((Object)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Object> invokeWithResponse(String resourceGroupName, String containerAppName, String logicAppName, String xMsLogicAppsProxyPath, LogicAppsProxyMethod xMsLogicAppsProxyMethod, Context context) {
        return (Response)this.invokeWithResponseAsync(resourceGroupName, containerAppName, logicAppName, xMsLogicAppsProxyPath, xMsLogicAppsProxyMethod, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Object invoke(String resourceGroupName, String containerAppName, String logicAppName, String xMsLogicAppsProxyPath, LogicAppsProxyMethod xMsLogicAppsProxyMethod) {
        return this.invokeWithResponse(resourceGroupName, containerAppName, logicAppName, xMsLogicAppsProxyPath, xMsLogicAppsProxyMethod, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<WorkflowEnvelopeInner>> listWorkflowsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listWorkflowsNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((WorkflowEnvelopeCollection)res.getValue()).value(), ((WorkflowEnvelopeCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<WorkflowEnvelopeInner>> listWorkflowsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listWorkflowsNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((WorkflowEnvelopeCollection)res.getValue()).value(), ((WorkflowEnvelopeCollection)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ContainerAppsApiClie")
    public static interface LogicAppsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/containerApps/{containerAppName}/providers/Microsoft.App/logicApps/{logicAppName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<LogicAppInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="containerAppName") String var4, @PathParam(value="logicAppName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/containerApps/{containerAppName}/providers/Microsoft.App/logicApps/{logicAppName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<LogicAppInner>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="containerAppName") String var4, @PathParam(value="logicAppName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") LogicAppInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/containerApps/{containerAppName}/providers/Microsoft.App/logicApps/{logicAppName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="containerAppName") String var4, @PathParam(value="logicAppName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/containerApps/{containerAppName}/providers/Microsoft.App/logicApps/{logicAppName}/workflows")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<WorkflowEnvelopeCollection>> listWorkflows(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="containerAppName") String var4, @PathParam(value="logicAppName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/containerApps/{containerAppName}/providers/Microsoft.App/logicApps/{logicAppName}/workflows/{workflowName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<WorkflowEnvelopeInner>> getWorkflow(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="containerAppName") String var4, @PathParam(value="logicAppName") String var5, @PathParam(value="workflowName") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/containerApps/{containerAppName}/providers/Microsoft.App/logicApps/{logicAppName}/deployWorkflowArtifacts")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<Void>> deployWorkflowArtifacts(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="containerAppName") String var4, @PathParam(value="logicAppName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") WorkflowArtifacts var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/containerApps/{containerAppName}/providers/Microsoft.App/logicApps/{logicAppName}/listWorkflowsConnections")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<WorkflowEnvelopeInner>> listWorkflowsConnections(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="containerAppName") String var4, @PathParam(value="logicAppName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/containerApps/{containerAppName}/providers/Microsoft.App/logicApps/{logicAppName}/invoke")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<Object>> invoke(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="containerAppName") String var4, @PathParam(value="logicAppName") String var5, @HeaderParam(value="x-ms-logicApps-proxy-path") String var6, @HeaderParam(value="x-ms-logicApps-proxy-method") LogicAppsProxyMethod var7, @QueryParam(value="api-version") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<WorkflowEnvelopeCollection>> listWorkflowsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

