/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.appcontainers.fluent.ManagedEnvironmentDiagnosticsClient;
import com.azure.resourcemanager.appcontainers.fluent.models.DiagnosticsCollectionInner;
import com.azure.resourcemanager.appcontainers.fluent.models.DiagnosticsInner;
import com.azure.resourcemanager.appcontainers.implementation.ContainerAppsApiClientImpl;
import com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException;
import reactor.core.publisher.Mono;

public final class ManagedEnvironmentDiagnosticsClientImpl
implements ManagedEnvironmentDiagnosticsClient {
    private final ManagedEnvironmentDiagnosticsService service;
    private final ContainerAppsApiClientImpl client;

    ManagedEnvironmentDiagnosticsClientImpl(ContainerAppsApiClientImpl client) {
        this.service = (ManagedEnvironmentDiagnosticsService)RestProxy.create(ManagedEnvironmentDiagnosticsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DiagnosticsCollectionInner>> listDetectorsWithResponseAsync(String resourceGroupName, String environmentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listDetectors(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, environmentName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DiagnosticsCollectionInner>> listDetectorsWithResponseAsync(String resourceGroupName, String environmentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listDetectors(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, environmentName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DiagnosticsCollectionInner> listDetectorsAsync(String resourceGroupName, String environmentName) {
        return this.listDetectorsWithResponseAsync(resourceGroupName, environmentName).flatMap(res -> Mono.justOrEmpty((Object)((DiagnosticsCollectionInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DiagnosticsCollectionInner> listDetectorsWithResponse(String resourceGroupName, String environmentName, Context context) {
        return (Response)this.listDetectorsWithResponseAsync(resourceGroupName, environmentName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DiagnosticsCollectionInner listDetectors(String resourceGroupName, String environmentName) {
        return (DiagnosticsCollectionInner)this.listDetectorsWithResponse(resourceGroupName, environmentName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DiagnosticsInner>> getDetectorWithResponseAsync(String resourceGroupName, String environmentName, String detectorName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (detectorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter detectorName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getDetector(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, environmentName, detectorName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DiagnosticsInner>> getDetectorWithResponseAsync(String resourceGroupName, String environmentName, String detectorName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (detectorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter detectorName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getDetector(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, environmentName, detectorName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DiagnosticsInner> getDetectorAsync(String resourceGroupName, String environmentName, String detectorName) {
        return this.getDetectorWithResponseAsync(resourceGroupName, environmentName, detectorName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((DiagnosticsInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DiagnosticsInner> getDetectorWithResponse(String resourceGroupName, String environmentName, String detectorName, Context context) {
        return (Response)this.getDetectorWithResponseAsync(resourceGroupName, environmentName, detectorName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DiagnosticsInner getDetector(String resourceGroupName, String environmentName, String detectorName) {
        return (DiagnosticsInner)((Object)this.getDetectorWithResponse(resourceGroupName, environmentName, detectorName, Context.NONE).getValue());
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ContainerAppsApiClie")
    public static interface ManagedEnvironmentDiagnosticsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/managedEnvironments/{environmentName}/detectors")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<DiagnosticsCollectionInner>> listDetectors(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="environmentName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/managedEnvironments/{environmentName}/detectors/{detectorName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<DiagnosticsInner>> getDetector(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="environmentName") String var4, @PathParam(value="detectorName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);
    }
}

