/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.ContainerResources;
import com.azure.resourcemanager.appcontainers.models.EnvironmentVar;
import com.azure.resourcemanager.appcontainers.models.ImageType;
import com.azure.resourcemanager.appcontainers.models.VolumeMount;
import java.io.IOException;
import java.util.List;

public class BaseContainer
implements JsonSerializable<BaseContainer> {
    private String image;
    private ImageType imageType;
    private String name;
    private List<String> command;
    private List<String> args;
    private List<EnvironmentVar> env;
    private ContainerResources resources;
    private List<VolumeMount> volumeMounts;

    public String image() {
        return this.image;
    }

    public BaseContainer withImage(String image) {
        this.image = image;
        return this;
    }

    public ImageType imageType() {
        return this.imageType;
    }

    public BaseContainer withImageType(ImageType imageType) {
        this.imageType = imageType;
        return this;
    }

    public String name() {
        return this.name;
    }

    public BaseContainer withName(String name) {
        this.name = name;
        return this;
    }

    public List<String> command() {
        return this.command;
    }

    public BaseContainer withCommand(List<String> command) {
        this.command = command;
        return this;
    }

    public List<String> args() {
        return this.args;
    }

    public BaseContainer withArgs(List<String> args) {
        this.args = args;
        return this;
    }

    public List<EnvironmentVar> env() {
        return this.env;
    }

    public BaseContainer withEnv(List<EnvironmentVar> env) {
        this.env = env;
        return this;
    }

    public ContainerResources resources() {
        return this.resources;
    }

    public BaseContainer withResources(ContainerResources resources) {
        this.resources = resources;
        return this;
    }

    public List<VolumeMount> volumeMounts() {
        return this.volumeMounts;
    }

    public BaseContainer withVolumeMounts(List<VolumeMount> volumeMounts) {
        this.volumeMounts = volumeMounts;
        return this;
    }

    public void validate() {
        if (this.env() != null) {
            this.env().forEach(e -> e.validate());
        }
        if (this.resources() != null) {
            this.resources().validate();
        }
        if (this.volumeMounts() != null) {
            this.volumeMounts().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("image", this.image);
        jsonWriter.writeStringField("imageType", this.imageType == null ? null : this.imageType.toString());
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeArrayField("command", this.command, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("args", this.args, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("env", this.env, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("resources", (JsonSerializable)this.resources);
        jsonWriter.writeArrayField("volumeMounts", this.volumeMounts, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static BaseContainer fromJson(JsonReader jsonReader) throws IOException {
        return (BaseContainer)jsonReader.readObject(reader -> {
            BaseContainer deserializedBaseContainer = new BaseContainer();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("image".equals(fieldName)) {
                    deserializedBaseContainer.image = reader.getString();
                    continue;
                }
                if ("imageType".equals(fieldName)) {
                    deserializedBaseContainer.imageType = ImageType.fromString(reader.getString());
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedBaseContainer.name = reader.getString();
                    continue;
                }
                if ("command".equals(fieldName)) {
                    List command;
                    deserializedBaseContainer.command = command = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("args".equals(fieldName)) {
                    List args;
                    deserializedBaseContainer.args = args = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("env".equals(fieldName)) {
                    List env;
                    deserializedBaseContainer.env = env = reader.readArray(reader1 -> EnvironmentVar.fromJson(reader1));
                    continue;
                }
                if ("resources".equals(fieldName)) {
                    deserializedBaseContainer.resources = ContainerResources.fromJson(reader);
                    continue;
                }
                if ("volumeMounts".equals(fieldName)) {
                    List volumeMounts;
                    deserializedBaseContainer.volumeMounts = volumeMounts = reader.readArray(reader1 -> VolumeMount.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBaseContainer;
        });
    }
}

