/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.BillingMeterProperties;
import java.io.IOException;

public final class BillingMeter
implements JsonSerializable<BillingMeter> {
    private String id;
    private String name;
    private String type;
    private String location;
    private BillingMeterProperties properties;

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public String location() {
        return this.location;
    }

    public BillingMeter withLocation(String location) {
        this.location = location;
        return this;
    }

    public BillingMeterProperties properties() {
        return this.properties;
    }

    public BillingMeter withProperties(BillingMeterProperties properties) {
        this.properties = properties;
        return this;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static BillingMeter fromJson(JsonReader jsonReader) throws IOException {
        return (BillingMeter)jsonReader.readObject(reader -> {
            BillingMeter deserializedBillingMeter = new BillingMeter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedBillingMeter.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedBillingMeter.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedBillingMeter.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedBillingMeter.location = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedBillingMeter.properties = BillingMeterProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBillingMeter;
        });
    }
}

