/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.fluent.models.BuildResourceInner;
import java.io.IOException;
import java.util.List;

public final class BuildCollection
implements JsonSerializable<BuildCollection> {
    private List<BuildResourceInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(BuildCollection.class);

    public List<BuildResourceInner> value() {
        return this.value;
    }

    public BuildCollection withValue(List<BuildResourceInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public BuildCollection withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model BuildCollection"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static BuildCollection fromJson(JsonReader jsonReader) throws IOException {
        return (BuildCollection)jsonReader.readObject(reader -> {
            BuildCollection deserializedBuildCollection = new BuildCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedBuildCollection.value = value = reader.readArray(reader1 -> BuildResourceInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedBuildCollection.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBuildCollection;
        });
    }
}

