/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appcontainers.fluent.models.BuildResourceInner;
import com.azure.resourcemanager.appcontainers.models.BuildConfiguration;
import com.azure.resourcemanager.appcontainers.models.BuildProvisioningState;
import com.azure.resourcemanager.appcontainers.models.BuildStatus;
import com.azure.resourcemanager.appcontainers.models.ContainerRegistryWithCustomImage;

public interface BuildResource {
    public String id();

    public String name();

    public String type();

    public SystemData systemData();

    public BuildProvisioningState provisioningState();

    public BuildStatus buildStatus();

    public ContainerRegistryWithCustomImage destinationContainerRegistry();

    public BuildConfiguration configuration();

    public String uploadEndpoint();

    public String logStreamEndpoint();

    public String tokenEndpoint();

    public String resourceGroupName();

    public BuildResourceInner innerModel();

    public Update update();

    public BuildResource refresh();

    public BuildResource refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithConfiguration {
            public Update withConfiguration(BuildConfiguration var1);
        }

        public static interface WithDestinationContainerRegistry {
            public Update withDestinationContainerRegistry(ContainerRegistryWithCustomImage var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithDestinationContainerRegistry,
    UpdateStages.WithConfiguration {
        public BuildResource apply();

        public BuildResource apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithConfiguration {
            public WithCreate withConfiguration(BuildConfiguration var1);
        }

        public static interface WithDestinationContainerRegistry {
            public WithCreate withDestinationContainerRegistry(ContainerRegistryWithCustomImage var1);
        }

        public static interface WithCreate
        extends WithDestinationContainerRegistry,
        WithConfiguration {
            public BuildResource create();

            public BuildResource create(Context var1);
        }

        public static interface WithParentResource {
            public WithCreate withExistingBuilder(String var1, String var2);
        }

        public static interface Blank
        extends WithParentResource {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithCreate {
    }
}

