/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.BaseContainer;
import com.azure.resourcemanager.appcontainers.models.ContainerAppProbe;
import com.azure.resourcemanager.appcontainers.models.ContainerResources;
import com.azure.resourcemanager.appcontainers.models.EnvironmentVar;
import com.azure.resourcemanager.appcontainers.models.ImageType;
import com.azure.resourcemanager.appcontainers.models.VolumeMount;
import java.io.IOException;
import java.util.List;

public final class Container
extends BaseContainer {
    private List<ContainerAppProbe> probes;

    public List<ContainerAppProbe> probes() {
        return this.probes;
    }

    public Container withProbes(List<ContainerAppProbe> probes) {
        this.probes = probes;
        return this;
    }

    @Override
    public Container withImage(String image) {
        super.withImage(image);
        return this;
    }

    @Override
    public Container withImageType(ImageType imageType) {
        super.withImageType(imageType);
        return this;
    }

    @Override
    public Container withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public Container withCommand(List<String> command) {
        super.withCommand(command);
        return this;
    }

    @Override
    public Container withArgs(List<String> args) {
        super.withArgs(args);
        return this;
    }

    @Override
    public Container withEnv(List<EnvironmentVar> env) {
        super.withEnv(env);
        return this;
    }

    @Override
    public Container withResources(ContainerResources resources) {
        super.withResources(resources);
        return this;
    }

    @Override
    public Container withVolumeMounts(List<VolumeMount> volumeMounts) {
        super.withVolumeMounts(volumeMounts);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.probes() != null) {
            this.probes().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("image", this.image());
        jsonWriter.writeStringField("imageType", this.imageType() == null ? null : this.imageType().toString());
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeArrayField("command", this.command(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("args", this.args(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("env", this.env(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("resources", (JsonSerializable)this.resources());
        jsonWriter.writeArrayField("volumeMounts", this.volumeMounts(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("probes", this.probes, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static Container fromJson(JsonReader jsonReader) throws IOException {
        return (Container)jsonReader.readObject(reader -> {
            Container deserializedContainer = new Container();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("image".equals(fieldName)) {
                    deserializedContainer.withImage(reader.getString());
                    continue;
                }
                if ("imageType".equals(fieldName)) {
                    deserializedContainer.withImageType(ImageType.fromString(reader.getString()));
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedContainer.withName(reader.getString());
                    continue;
                }
                if ("command".equals(fieldName)) {
                    List command = reader.readArray(reader1 -> reader1.getString());
                    deserializedContainer.withCommand(command);
                    continue;
                }
                if ("args".equals(fieldName)) {
                    List args = reader.readArray(reader1 -> reader1.getString());
                    deserializedContainer.withArgs(args);
                    continue;
                }
                if ("env".equals(fieldName)) {
                    List env = reader.readArray(reader1 -> EnvironmentVar.fromJson(reader1));
                    deserializedContainer.withEnv(env);
                    continue;
                }
                if ("resources".equals(fieldName)) {
                    deserializedContainer.withResources(ContainerResources.fromJson(reader));
                    continue;
                }
                if ("volumeMounts".equals(fieldName)) {
                    List volumeMounts = reader.readArray(reader1 -> VolumeMount.fromJson(reader1));
                    deserializedContainer.withVolumeMounts(volumeMounts);
                    continue;
                }
                if ("probes".equals(fieldName)) {
                    List probes;
                    deserializedContainer.probes = probes = reader.readArray(reader1 -> ContainerAppProbe.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedContainer;
        });
    }
}

