/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.fluent.models.ContainerAppsBuildResourceInner;
import java.io.IOException;
import java.util.List;

public final class ContainerAppsBuildCollection
implements JsonSerializable<ContainerAppsBuildCollection> {
    private List<ContainerAppsBuildResourceInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(ContainerAppsBuildCollection.class);

    public List<ContainerAppsBuildResourceInner> value() {
        return this.value;
    }

    public ContainerAppsBuildCollection withValue(List<ContainerAppsBuildResourceInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public ContainerAppsBuildCollection withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model ContainerAppsBuildCollection"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static ContainerAppsBuildCollection fromJson(JsonReader jsonReader) throws IOException {
        return (ContainerAppsBuildCollection)jsonReader.readObject(reader -> {
            ContainerAppsBuildCollection deserializedContainerAppsBuildCollection = new ContainerAppsBuildCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedContainerAppsBuildCollection.value = value = reader.readArray(reader1 -> ContainerAppsBuildResourceInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedContainerAppsBuildCollection.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedContainerAppsBuildCollection;
        });
    }
}

