/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.EnvironmentVariable;
import com.azure.resourcemanager.appcontainers.models.PreBuildStep;
import java.io.IOException;
import java.util.List;

public final class ContainerAppsBuildConfiguration
implements JsonSerializable<ContainerAppsBuildConfiguration> {
    private String baseOs;
    private String platform;
    private String platformVersion;
    private List<EnvironmentVariable> environmentVariables;
    private List<PreBuildStep> preBuildSteps;

    public String baseOs() {
        return this.baseOs;
    }

    public String platform() {
        return this.platform;
    }

    public String platformVersion() {
        return this.platformVersion;
    }

    public List<EnvironmentVariable> environmentVariables() {
        return this.environmentVariables;
    }

    public List<PreBuildStep> preBuildSteps() {
        return this.preBuildSteps;
    }

    public void validate() {
        if (this.environmentVariables() != null) {
            this.environmentVariables().forEach(e -> e.validate());
        }
        if (this.preBuildSteps() != null) {
            this.preBuildSteps().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static ContainerAppsBuildConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (ContainerAppsBuildConfiguration)jsonReader.readObject(reader -> {
            ContainerAppsBuildConfiguration deserializedContainerAppsBuildConfiguration = new ContainerAppsBuildConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("baseOs".equals(fieldName)) {
                    deserializedContainerAppsBuildConfiguration.baseOs = reader.getString();
                    continue;
                }
                if ("platform".equals(fieldName)) {
                    deserializedContainerAppsBuildConfiguration.platform = reader.getString();
                    continue;
                }
                if ("platformVersion".equals(fieldName)) {
                    deserializedContainerAppsBuildConfiguration.platformVersion = reader.getString();
                    continue;
                }
                if ("environmentVariables".equals(fieldName)) {
                    List environmentVariables;
                    deserializedContainerAppsBuildConfiguration.environmentVariables = environmentVariables = reader.readArray(reader1 -> EnvironmentVariable.fromJson(reader1));
                    continue;
                }
                if ("preBuildSteps".equals(fieldName)) {
                    List preBuildSteps;
                    deserializedContainerAppsBuildConfiguration.preBuildSteps = preBuildSteps = reader.readArray(reader1 -> PreBuildStep.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedContainerAppsBuildConfiguration;
        });
    }
}

