/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.DaprSubscriptionRouteRule;
import java.io.IOException;
import java.util.List;

public final class DaprSubscriptionRoutes
implements JsonSerializable<DaprSubscriptionRoutes> {
    private List<DaprSubscriptionRouteRule> rules;
    private String defaultProperty;

    public List<DaprSubscriptionRouteRule> rules() {
        return this.rules;
    }

    public DaprSubscriptionRoutes withRules(List<DaprSubscriptionRouteRule> rules) {
        this.rules = rules;
        return this;
    }

    public String defaultProperty() {
        return this.defaultProperty;
    }

    public DaprSubscriptionRoutes withDefaultProperty(String defaultProperty) {
        this.defaultProperty = defaultProperty;
        return this;
    }

    public void validate() {
        if (this.rules() != null) {
            this.rules().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("rules", this.rules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("default", this.defaultProperty);
        return jsonWriter.writeEndObject();
    }

    public static DaprSubscriptionRoutes fromJson(JsonReader jsonReader) throws IOException {
        return (DaprSubscriptionRoutes)jsonReader.readObject(reader -> {
            DaprSubscriptionRoutes deserializedDaprSubscriptionRoutes = new DaprSubscriptionRoutes();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("rules".equals(fieldName)) {
                    List rules;
                    deserializedDaprSubscriptionRoutes.rules = rules = reader.readArray(reader1 -> DaprSubscriptionRouteRule.fromJson(reader1));
                    continue;
                }
                if ("default".equals(fieldName)) {
                    deserializedDaprSubscriptionRoutes.defaultProperty = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDaprSubscriptionRoutes;
        });
    }
}

