/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.DataDogConfiguration;
import com.azure.resourcemanager.appcontainers.models.OtlpConfiguration;
import java.io.IOException;
import java.util.List;

public final class DestinationsConfiguration
implements JsonSerializable<DestinationsConfiguration> {
    private DataDogConfiguration dataDogConfiguration;
    private List<OtlpConfiguration> otlpConfigurations;

    public DataDogConfiguration dataDogConfiguration() {
        return this.dataDogConfiguration;
    }

    public DestinationsConfiguration withDataDogConfiguration(DataDogConfiguration dataDogConfiguration) {
        this.dataDogConfiguration = dataDogConfiguration;
        return this;
    }

    public List<OtlpConfiguration> otlpConfigurations() {
        return this.otlpConfigurations;
    }

    public DestinationsConfiguration withOtlpConfigurations(List<OtlpConfiguration> otlpConfigurations) {
        this.otlpConfigurations = otlpConfigurations;
        return this;
    }

    public void validate() {
        if (this.dataDogConfiguration() != null) {
            this.dataDogConfiguration().validate();
        }
        if (this.otlpConfigurations() != null) {
            this.otlpConfigurations().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("dataDogConfiguration", (JsonSerializable)this.dataDogConfiguration);
        jsonWriter.writeArrayField("otlpConfigurations", this.otlpConfigurations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static DestinationsConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (DestinationsConfiguration)jsonReader.readObject(reader -> {
            DestinationsConfiguration deserializedDestinationsConfiguration = new DestinationsConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("dataDogConfiguration".equals(fieldName)) {
                    deserializedDestinationsConfiguration.dataDogConfiguration = DataDogConfiguration.fromJson(reader);
                    continue;
                }
                if ("otlpConfigurations".equals(fieldName)) {
                    List otlpConfigurations;
                    deserializedDestinationsConfiguration.otlpConfigurations = otlpConfigurations = reader.readArray(reader1 -> OtlpConfiguration.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDestinationsConfiguration;
        });
    }
}

