/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.ExecutionType;
import java.io.IOException;

public final class DynamicPoolConfiguration
implements JsonSerializable<DynamicPoolConfiguration> {
    private ExecutionType executionType;
    private Integer cooldownPeriodInSeconds;

    public ExecutionType executionType() {
        return this.executionType;
    }

    public DynamicPoolConfiguration withExecutionType(ExecutionType executionType) {
        this.executionType = executionType;
        return this;
    }

    public Integer cooldownPeriodInSeconds() {
        return this.cooldownPeriodInSeconds;
    }

    public DynamicPoolConfiguration withCooldownPeriodInSeconds(Integer cooldownPeriodInSeconds) {
        this.cooldownPeriodInSeconds = cooldownPeriodInSeconds;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("executionType", this.executionType == null ? null : this.executionType.toString());
        jsonWriter.writeNumberField("cooldownPeriodInSeconds", (Number)this.cooldownPeriodInSeconds);
        return jsonWriter.writeEndObject();
    }

    public static DynamicPoolConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (DynamicPoolConfiguration)jsonReader.readObject(reader -> {
            DynamicPoolConfiguration deserializedDynamicPoolConfiguration = new DynamicPoolConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("executionType".equals(fieldName)) {
                    deserializedDynamicPoolConfiguration.executionType = ExecutionType.fromString(reader.getString());
                    continue;
                }
                if ("cooldownPeriodInSeconds".equals(fieldName)) {
                    deserializedDynamicPoolConfiguration.cooldownPeriodInSeconds = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDynamicPoolConfiguration;
        });
    }
}

