/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.ReplicaExecutionStatus;
import java.io.IOException;
import java.util.List;

public final class ExecutionStatus
implements JsonSerializable<ExecutionStatus> {
    private List<ReplicaExecutionStatus> replicas;

    public List<ReplicaExecutionStatus> replicas() {
        return this.replicas;
    }

    public ExecutionStatus withReplicas(List<ReplicaExecutionStatus> replicas) {
        this.replicas = replicas;
        return this;
    }

    public void validate() {
        if (this.replicas() != null) {
            this.replicas().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("replicas", this.replicas, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ExecutionStatus fromJson(JsonReader jsonReader) throws IOException {
        return (ExecutionStatus)jsonReader.readObject(reader -> {
            ExecutionStatus deserializedExecutionStatus = new ExecutionStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("replicas".equals(fieldName)) {
                    List replicas;
                    deserializedExecutionStatus.replicas = replicas = reader.readArray(reader1 -> ReplicaExecutionStatus.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExecutionStatus;
        });
    }
}

