/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.fluent.models.HttpRetryPolicyMatches;
import com.azure.resourcemanager.appcontainers.fluent.models.HttpRetryPolicyRetryBackOff;
import com.azure.resourcemanager.appcontainers.models.HeaderMatch;
import java.io.IOException;
import java.util.List;

public final class HttpRetryPolicy
implements JsonSerializable<HttpRetryPolicy> {
    private Integer maxRetries;
    private HttpRetryPolicyRetryBackOff innerRetryBackOff;
    private HttpRetryPolicyMatches innerMatches;

    public Integer maxRetries() {
        return this.maxRetries;
    }

    public HttpRetryPolicy withMaxRetries(Integer maxRetries) {
        this.maxRetries = maxRetries;
        return this;
    }

    private HttpRetryPolicyRetryBackOff innerRetryBackOff() {
        return this.innerRetryBackOff;
    }

    private HttpRetryPolicyMatches innerMatches() {
        return this.innerMatches;
    }

    public Long initialDelayInMilliseconds() {
        return this.innerRetryBackOff() == null ? null : this.innerRetryBackOff().initialDelayInMilliseconds();
    }

    public HttpRetryPolicy withInitialDelayInMilliseconds(Long initialDelayInMilliseconds) {
        if (this.innerRetryBackOff() == null) {
            this.innerRetryBackOff = new HttpRetryPolicyRetryBackOff();
        }
        this.innerRetryBackOff().withInitialDelayInMilliseconds(initialDelayInMilliseconds);
        return this;
    }

    public Long maxIntervalInMilliseconds() {
        return this.innerRetryBackOff() == null ? null : this.innerRetryBackOff().maxIntervalInMilliseconds();
    }

    public HttpRetryPolicy withMaxIntervalInMilliseconds(Long maxIntervalInMilliseconds) {
        if (this.innerRetryBackOff() == null) {
            this.innerRetryBackOff = new HttpRetryPolicyRetryBackOff();
        }
        this.innerRetryBackOff().withMaxIntervalInMilliseconds(maxIntervalInMilliseconds);
        return this;
    }

    public List<HeaderMatch> headers() {
        return this.innerMatches() == null ? null : this.innerMatches().headers();
    }

    public HttpRetryPolicy withHeaders(List<HeaderMatch> headers) {
        if (this.innerMatches() == null) {
            this.innerMatches = new HttpRetryPolicyMatches();
        }
        this.innerMatches().withHeaders(headers);
        return this;
    }

    public List<Integer> httpStatusCodes() {
        return this.innerMatches() == null ? null : this.innerMatches().httpStatusCodes();
    }

    public HttpRetryPolicy withHttpStatusCodes(List<Integer> httpStatusCodes) {
        if (this.innerMatches() == null) {
            this.innerMatches = new HttpRetryPolicyMatches();
        }
        this.innerMatches().withHttpStatusCodes(httpStatusCodes);
        return this;
    }

    public List<String> errors() {
        return this.innerMatches() == null ? null : this.innerMatches().errors();
    }

    public HttpRetryPolicy withErrors(List<String> errors) {
        if (this.innerMatches() == null) {
            this.innerMatches = new HttpRetryPolicyMatches();
        }
        this.innerMatches().withErrors(errors);
        return this;
    }

    public void validate() {
        if (this.innerRetryBackOff() != null) {
            this.innerRetryBackOff().validate();
        }
        if (this.innerMatches() != null) {
            this.innerMatches().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("maxRetries", (Number)this.maxRetries);
        jsonWriter.writeJsonField("retryBackOff", (JsonSerializable)this.innerRetryBackOff);
        jsonWriter.writeJsonField("matches", (JsonSerializable)this.innerMatches);
        return jsonWriter.writeEndObject();
    }

    public static HttpRetryPolicy fromJson(JsonReader jsonReader) throws IOException {
        return (HttpRetryPolicy)jsonReader.readObject(reader -> {
            HttpRetryPolicy deserializedHttpRetryPolicy = new HttpRetryPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("maxRetries".equals(fieldName)) {
                    deserializedHttpRetryPolicy.maxRetries = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("retryBackOff".equals(fieldName)) {
                    deserializedHttpRetryPolicy.innerRetryBackOff = HttpRetryPolicyRetryBackOff.fromJson(reader);
                    continue;
                }
                if ("matches".equals(fieldName)) {
                    deserializedHttpRetryPolicy.innerMatches = HttpRetryPolicyMatches.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHttpRetryPolicy;
        });
    }
}

