/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class JobConfigurationScheduleTriggerConfig
implements JsonSerializable<JobConfigurationScheduleTriggerConfig> {
    private Integer replicaCompletionCount;
    private String cronExpression;
    private Integer parallelism;
    private static final ClientLogger LOGGER = new ClientLogger(JobConfigurationScheduleTriggerConfig.class);

    public Integer replicaCompletionCount() {
        return this.replicaCompletionCount;
    }

    public JobConfigurationScheduleTriggerConfig withReplicaCompletionCount(Integer replicaCompletionCount) {
        this.replicaCompletionCount = replicaCompletionCount;
        return this;
    }

    public String cronExpression() {
        return this.cronExpression;
    }

    public JobConfigurationScheduleTriggerConfig withCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
        return this;
    }

    public Integer parallelism() {
        return this.parallelism;
    }

    public JobConfigurationScheduleTriggerConfig withParallelism(Integer parallelism) {
        this.parallelism = parallelism;
        return this;
    }

    public void validate() {
        if (this.cronExpression() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property cronExpression in model JobConfigurationScheduleTriggerConfig"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("cronExpression", this.cronExpression);
        jsonWriter.writeNumberField("replicaCompletionCount", (Number)this.replicaCompletionCount);
        jsonWriter.writeNumberField("parallelism", (Number)this.parallelism);
        return jsonWriter.writeEndObject();
    }

    public static JobConfigurationScheduleTriggerConfig fromJson(JsonReader jsonReader) throws IOException {
        return (JobConfigurationScheduleTriggerConfig)jsonReader.readObject(reader -> {
            JobConfigurationScheduleTriggerConfig deserializedJobConfigurationScheduleTriggerConfig = new JobConfigurationScheduleTriggerConfig();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("cronExpression".equals(fieldName)) {
                    deserializedJobConfigurationScheduleTriggerConfig.cronExpression = reader.getString();
                    continue;
                }
                if ("replicaCompletionCount".equals(fieldName)) {
                    deserializedJobConfigurationScheduleTriggerConfig.replicaCompletionCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("parallelism".equals(fieldName)) {
                    deserializedJobConfigurationScheduleTriggerConfig.parallelism = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedJobConfigurationScheduleTriggerConfig;
        });
    }
}

