/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.ExtendedLocation;
import com.azure.resourcemanager.appcontainers.models.JobPatchPropertiesProperties;
import com.azure.resourcemanager.appcontainers.models.ManagedServiceIdentity;
import java.io.IOException;
import java.util.Map;

public final class JobPatchProperties
implements JsonSerializable<JobPatchProperties> {
    private ExtendedLocation extendedLocation;
    private ManagedServiceIdentity identity;
    private Map<String, String> tags;
    private JobPatchPropertiesProperties properties;

    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    public JobPatchProperties withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    public JobPatchProperties withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public JobPatchProperties withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public JobPatchPropertiesProperties properties() {
        return this.properties;
    }

    public JobPatchProperties withProperties(JobPatchPropertiesProperties properties) {
        this.properties = properties;
        return this;
    }

    public void validate() {
        if (this.extendedLocation() != null) {
            this.extendedLocation().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.properties() != null) {
            this.properties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("extendedLocation", (JsonSerializable)this.extendedLocation);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static JobPatchProperties fromJson(JsonReader jsonReader) throws IOException {
        return (JobPatchProperties)jsonReader.readObject(reader -> {
            JobPatchProperties deserializedJobPatchProperties = new JobPatchProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("extendedLocation".equals(fieldName)) {
                    deserializedJobPatchProperties.extendedLocation = ExtendedLocation.fromJson(reader);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedJobPatchProperties.identity = ManagedServiceIdentity.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedJobPatchProperties.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedJobPatchProperties.properties = JobPatchPropertiesProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedJobPatchProperties;
        });
    }
}

