/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.Level;
import java.io.IOException;

public final class LoggerSetting
implements JsonSerializable<LoggerSetting> {
    private String logger;
    private Level level;
    private static final ClientLogger LOGGER = new ClientLogger(LoggerSetting.class);

    public String logger() {
        return this.logger;
    }

    public LoggerSetting withLogger(String logger) {
        this.logger = logger;
        return this;
    }

    public Level level() {
        return this.level;
    }

    public LoggerSetting withLevel(Level level) {
        this.level = level;
        return this;
    }

    public void validate() {
        if (this.logger() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property logger in model LoggerSetting"));
        }
        if (this.level() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property level in model LoggerSetting"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("logger", this.logger);
        jsonWriter.writeStringField("level", this.level == null ? null : this.level.toString());
        return jsonWriter.writeEndObject();
    }

    public static LoggerSetting fromJson(JsonReader jsonReader) throws IOException {
        return (LoggerSetting)jsonReader.readObject(reader -> {
            LoggerSetting deserializedLoggerSetting = new LoggerSetting();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("logger".equals(fieldName)) {
                    deserializedLoggerSetting.logger = reader.getString();
                    continue;
                }
                if ("level".equals(fieldName)) {
                    deserializedLoggerSetting.level = Level.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLoggerSetting;
        });
    }
}

