/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.AccessMode;
import java.io.IOException;

public final class NfsAzureFileProperties
implements JsonSerializable<NfsAzureFileProperties> {
    private String server;
    private AccessMode accessMode;
    private String shareName;

    public String server() {
        return this.server;
    }

    public NfsAzureFileProperties withServer(String server) {
        this.server = server;
        return this;
    }

    public AccessMode accessMode() {
        return this.accessMode;
    }

    public NfsAzureFileProperties withAccessMode(AccessMode accessMode) {
        this.accessMode = accessMode;
        return this;
    }

    public String shareName() {
        return this.shareName;
    }

    public NfsAzureFileProperties withShareName(String shareName) {
        this.shareName = shareName;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("server", this.server);
        jsonWriter.writeStringField("accessMode", this.accessMode == null ? null : this.accessMode.toString());
        jsonWriter.writeStringField("shareName", this.shareName);
        return jsonWriter.writeEndObject();
    }

    public static NfsAzureFileProperties fromJson(JsonReader jsonReader) throws IOException {
        return (NfsAzureFileProperties)jsonReader.readObject(reader -> {
            NfsAzureFileProperties deserializedNfsAzureFileProperties = new NfsAzureFileProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("server".equals(fieldName)) {
                    deserializedNfsAzureFileProperties.server = reader.getString();
                    continue;
                }
                if ("accessMode".equals(fieldName)) {
                    deserializedNfsAzureFileProperties.accessMode = AccessMode.fromString(reader.getString());
                    continue;
                }
                if ("shareName".equals(fieldName)) {
                    deserializedNfsAzureFileProperties.shareName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNfsAzureFileProperties;
        });
    }
}

