/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.Header;
import java.io.IOException;
import java.util.List;

public final class OtlpConfiguration
implements JsonSerializable<OtlpConfiguration> {
    private String name;
    private String endpoint;
    private Boolean insecure;
    private List<Header> headers;

    public String name() {
        return this.name;
    }

    public OtlpConfiguration withName(String name) {
        this.name = name;
        return this;
    }

    public String endpoint() {
        return this.endpoint;
    }

    public OtlpConfiguration withEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public Boolean insecure() {
        return this.insecure;
    }

    public OtlpConfiguration withInsecure(Boolean insecure) {
        this.insecure = insecure;
        return this;
    }

    public List<Header> headers() {
        return this.headers;
    }

    public OtlpConfiguration withHeaders(List<Header> headers) {
        this.headers = headers;
        return this;
    }

    public void validate() {
        if (this.headers() != null) {
            this.headers().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("endpoint", this.endpoint);
        jsonWriter.writeBooleanField("insecure", this.insecure);
        jsonWriter.writeArrayField("headers", this.headers, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static OtlpConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (OtlpConfiguration)jsonReader.readObject(reader -> {
            OtlpConfiguration deserializedOtlpConfiguration = new OtlpConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedOtlpConfiguration.name = reader.getString();
                    continue;
                }
                if ("endpoint".equals(fieldName)) {
                    deserializedOtlpConfiguration.endpoint = reader.getString();
                    continue;
                }
                if ("insecure".equals(fieldName)) {
                    deserializedOtlpConfiguration.insecure = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("headers".equals(fieldName)) {
                    List headers;
                    deserializedOtlpConfiguration.headers = headers = reader.readArray(reader1 -> Header.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOtlpConfiguration;
        });
    }
}

