/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.DetectionStatus;
import com.azure.resourcemanager.appcontainers.models.PatchDetailsNewLayer;
import com.azure.resourcemanager.appcontainers.models.PatchDetailsOldLayer;
import com.azure.resourcemanager.appcontainers.models.PatchType;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class PatchDetails
implements JsonSerializable<PatchDetails> {
    private String targetContainerName;
    private String targetImage;
    private OffsetDateTime lastDetectionTime;
    private DetectionStatus detectionStatus;
    private String newImageName;
    private PatchDetailsNewLayer newLayer;
    private PatchDetailsOldLayer oldLayer;
    private PatchType patchType;

    public String targetContainerName() {
        return this.targetContainerName;
    }

    public String targetImage() {
        return this.targetImage;
    }

    public OffsetDateTime lastDetectionTime() {
        return this.lastDetectionTime;
    }

    public DetectionStatus detectionStatus() {
        return this.detectionStatus;
    }

    public String newImageName() {
        return this.newImageName;
    }

    public PatchDetailsNewLayer newLayer() {
        return this.newLayer;
    }

    public PatchDetailsOldLayer oldLayer() {
        return this.oldLayer;
    }

    public PatchType patchType() {
        return this.patchType;
    }

    public void validate() {
        if (this.newLayer() != null) {
            this.newLayer().validate();
        }
        if (this.oldLayer() != null) {
            this.oldLayer().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static PatchDetails fromJson(JsonReader jsonReader) throws IOException {
        return (PatchDetails)jsonReader.readObject(reader -> {
            PatchDetails deserializedPatchDetails = new PatchDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("targetContainerName".equals(fieldName)) {
                    deserializedPatchDetails.targetContainerName = reader.getString();
                    continue;
                }
                if ("targetImage".equals(fieldName)) {
                    deserializedPatchDetails.targetImage = reader.getString();
                    continue;
                }
                if ("lastDetectionTime".equals(fieldName)) {
                    deserializedPatchDetails.lastDetectionTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("detectionStatus".equals(fieldName)) {
                    deserializedPatchDetails.detectionStatus = DetectionStatus.fromString(reader.getString());
                    continue;
                }
                if ("newImageName".equals(fieldName)) {
                    deserializedPatchDetails.newImageName = reader.getString();
                    continue;
                }
                if ("newLayer".equals(fieldName)) {
                    deserializedPatchDetails.newLayer = PatchDetailsNewLayer.fromJson(reader);
                    continue;
                }
                if ("oldLayer".equals(fieldName)) {
                    deserializedPatchDetails.oldLayer = PatchDetailsOldLayer.fromJson(reader);
                    continue;
                }
                if ("patchType".equals(fieldName)) {
                    deserializedPatchDetails.patchType = PatchType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPatchDetails;
        });
    }
}

