/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.PatchApplyStatus;
import com.azure.resourcemanager.appcontainers.models.PatchDetails;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class PatchProperties
implements JsonSerializable<PatchProperties> {
    private String targetEnvironmentId;
    private String targetContainerAppId;
    private String targetRevisionId;
    private PatchApplyStatus patchApplyStatus;
    private OffsetDateTime createdAt;
    private OffsetDateTime lastModifiedAt;
    private List<PatchDetails> patchDetails;

    public String targetEnvironmentId() {
        return this.targetEnvironmentId;
    }

    public PatchProperties withTargetEnvironmentId(String targetEnvironmentId) {
        this.targetEnvironmentId = targetEnvironmentId;
        return this;
    }

    public String targetContainerAppId() {
        return this.targetContainerAppId;
    }

    public PatchProperties withTargetContainerAppId(String targetContainerAppId) {
        this.targetContainerAppId = targetContainerAppId;
        return this;
    }

    public String targetRevisionId() {
        return this.targetRevisionId;
    }

    public PatchProperties withTargetRevisionId(String targetRevisionId) {
        this.targetRevisionId = targetRevisionId;
        return this;
    }

    public PatchApplyStatus patchApplyStatus() {
        return this.patchApplyStatus;
    }

    public OffsetDateTime createdAt() {
        return this.createdAt;
    }

    public OffsetDateTime lastModifiedAt() {
        return this.lastModifiedAt;
    }

    public List<PatchDetails> patchDetails() {
        return this.patchDetails;
    }

    public void validate() {
        if (this.patchDetails() != null) {
            this.patchDetails().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("targetEnvironmentId", this.targetEnvironmentId);
        jsonWriter.writeStringField("targetContainerAppId", this.targetContainerAppId);
        jsonWriter.writeStringField("targetRevisionId", this.targetRevisionId);
        return jsonWriter.writeEndObject();
    }

    public static PatchProperties fromJson(JsonReader jsonReader) throws IOException {
        return (PatchProperties)jsonReader.readObject(reader -> {
            PatchProperties deserializedPatchProperties = new PatchProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("targetEnvironmentId".equals(fieldName)) {
                    deserializedPatchProperties.targetEnvironmentId = reader.getString();
                    continue;
                }
                if ("targetContainerAppId".equals(fieldName)) {
                    deserializedPatchProperties.targetContainerAppId = reader.getString();
                    continue;
                }
                if ("targetRevisionId".equals(fieldName)) {
                    deserializedPatchProperties.targetRevisionId = reader.getString();
                    continue;
                }
                if ("patchApplyStatus".equals(fieldName)) {
                    deserializedPatchProperties.patchApplyStatus = PatchApplyStatus.fromString(reader.getString());
                    continue;
                }
                if ("createdAt".equals(fieldName)) {
                    deserializedPatchProperties.createdAt = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastModifiedAt".equals(fieldName)) {
                    deserializedPatchProperties.lastModifiedAt = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("patchDetails".equals(fieldName)) {
                    List patchDetails;
                    deserializedPatchProperties.patchDetails = patchDetails = reader.readArray(reader1 -> PatchDetails.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPatchProperties;
        });
    }
}

