/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.RuntimeJavaAgentLogging;
import java.io.IOException;

public final class RuntimeJavaAgent
implements JsonSerializable<RuntimeJavaAgent> {
    private Boolean enabled;
    private RuntimeJavaAgentLogging logging;

    public Boolean enabled() {
        return this.enabled;
    }

    public RuntimeJavaAgent withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public RuntimeJavaAgentLogging logging() {
        return this.logging;
    }

    public RuntimeJavaAgent withLogging(RuntimeJavaAgentLogging logging) {
        this.logging = logging;
        return this;
    }

    public void validate() {
        if (this.logging() != null) {
            this.logging().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeJsonField("logging", (JsonSerializable)this.logging);
        return jsonWriter.writeEndObject();
    }

    public static RuntimeJavaAgent fromJson(JsonReader jsonReader) throws IOException {
        return (RuntimeJavaAgent)jsonReader.readObject(reader -> {
            RuntimeJavaAgent deserializedRuntimeJavaAgent = new RuntimeJavaAgent();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("enabled".equals(fieldName)) {
                    deserializedRuntimeJavaAgent.enabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("logging".equals(fieldName)) {
                    deserializedRuntimeJavaAgent.logging = RuntimeJavaAgentLogging.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRuntimeJavaAgent;
        });
    }
}

